-- ----------------------------------------------------------------------------
-- Copyright (C) 2011 Nokia Gate5 GmbH Berlin
--
-- These coded instructions, statements, and computer programs contain
-- unpublished proprietary information of Nokia Gate5 GmbH Berlin, and
-- are copy protected by law. They may not be disclosed to third parties
-- or copied or duplicated in any form, in whole or in part, without the
-- specific, prior written permission of Nokia Gate5 GmbH Berlin.
-- ----------------------------------------------------------------------------
-- 				Authors: Raul Ferrandez, Fabian TP Riek
-- ----------------------------------------------------------------------------
--             Voice Skin: russian_f

description = "" 
output_type = "audio"
speaker = ""
gender = "f"
travel_mode = "1"
language = "Russian"
marc_code = "rus"
language_id = "16"
id = "16000"
config_file = "russian_f/config.lua"
audio_files_path = "russian_f/russian_female"
audio_files_version = "0.3.0.2012031601"
feature_list = { "metric", "imperial_uk", "" }
client_range = "[ client >= 1.4.6.0 ; client < 1.7.0.0 ]"

down = 1
up = 2

maneuver_turns = {
    ["NO_TURN"] = {"g5man_001e", "g5man_001"},
    ["KEEP_MIDDLE"] = {"g5man_032--01s", "g5man_032--01"},
    ["KEEP_RIGHT"] = {"g5tur_001e", "g5tur_001"},
    ["LIGHT_RIGHT"] = {"g5tur_002e", "g5tur_002"},
    ["QUITE_RIGHT"] = {"g5tur_003-01ve", "g5tur_003-01v"},
    ["HEAVY_RIGHT"] = {"g5tur_004e", "g5tur_004"},
    ["RETURN"] = {"g5man_004e", "g5man_004"},
    ["HEAVY_LEFT"] = {"g5tul_004e", "g5tul_004"},
    ["QUITE_LEFT"] = {"g5tul_003-01e", "g5tul_003-01"},
    ["LIGHT_LEFT"] = {"g5tul_002e", "g5tul_002"},
    ["KEEP_LEFT"] = {"g5tul_001e", "g5tul_001"},
    ["nil"] = {nil, nil},
    ["UNDEFINED"] = {nil, nil}
}

maneuver_check = {
    ["END"] = {"g5ann_003", "g5ann_003"},                  -- You will reached your destination
    ["STOPOVER"] = {"g5ann_002e_alt2", "g5ann_002e_alt2"},         -- You will reached a stopover
    ["JUNCTION"] = {nil, nil},                                     -- No voice file needed -> check maneuver_turn
    ["PASS_JUNCTION"] = {nil, nil},                                -- the junction
    ["ROUNDABOUT"] = {"g5mod_005p", "g5mod_005p"},                 -- At the roundabout
    ["EXIT_ROUNDABOUT"] = {"g5ext_000e", "g5ext_000"},             -- take the exit
    ["UTURN"] = {"g5man_004e", "g5man_004"},                       -- Make a uturn
    ["ENTER_HIGHWAY"] = {"g5man_005e", "g5man_005"},
    ["LEAVE_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},               -- take the exit
    ["CHANGE_HIGHWAY"] = {"g5man_006e", "g5man_006"},
    ["CONTINUE_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},
    ["ENTER_URBAN_HIGHWAY"] = {"g5man_005e", "g5man_005"},
    ["LEAVE_URBAN_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},         -- take the exit
    ["CHANGE_URBAN_HIGHWAY"] = {"g5man_006e", "g5man_006"},
    ["CONTINUE_URBAN_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},
    ["DRIVE_TO_NEAREST_ROAD"] = {"g5serv_001e", "g5serv_001e"},    -- drive to nearest road 
    ["FERRY"] = {"g5serv_004e", "g5serv_004"}
}

exit_number_check = {
    [1] = {"g5ext_001_6e","g5ext_001_6"},                   -- take the first exit
    [2] = {"g5ext_002_6e","g5ext_002_6"},                   -- take the second exit
    [3] = {"g5ext_003_6e","g5ext_003_6"},                   -- take the third exit
    [4] = {"g5ext_004_6e","g5ext_004_6"},                   -- take the fourth exit
    [5] = {"g5ext_005_6e","g5ext_005_6"},                   -- take the fifth exit
    [6] = {"g5ext_006_6e","g5ext_006_6"},                   -- take the sixth exit
    [7] = {"g5ext_007_6e","g5ext_007_6"},                   -- take the seventh exit
    [8] = {"g5ext_008_6e","g5ext_008_6"},                   -- take the eighth exit
    [9] = {"g5ext_009_6e","g5ext_009_6"},                   -- take the ninth exit
    [10] = {"g5ext_010_6e","g5ext_010_6"},                  -- take the tenth exit
    [11] = {"g5ext_011_6e","g5ext_011_6"},                  -- take the eleventh exit
    [12] = {"g5ext_012_6e","g5ext_012_6"}                   -- take the twelfth exit
}

distances = {
    [50] = {"g5num_050", "g5num_050"},
    [100] = {"g5num_100", "g5num_100"},
    [150] = {"g5num_150", "g5num_150"},
    [200] = {"g5num_200", "g5num_200"},
    [250] = {"g5num_250", "g5num_250"},
    [300] = {"g5num_300", "g5num_300"},
    [400] = {"g5num_400", "g5num_400"},
    [500] = {"g5num_500", "g5num_500"},
    [600] = {"g5num_600", "g5num_600"},
    [700] = {"g5num_700", "g5num_700"},
    [800] = {"g5num_800", "g5num_800"},
    [900] = {"g5num_900", "g5num_900"},
    [1] = {"g5num_001", "g5num_001_v"},
    [2] = {"g5num_002", "g5num_002--01"},
    [3] = {"g5num_003", "g5num_003"},
    [4] = {"g5num_004", "g5num_004"},
    [5] = {"g5num_005", "g5num_005"},
    [6] = {"g5num_006", "g5num_006"},
    [7] = {"g5num_007", "g5num_007"},
    [8] = {"g5num_008", "g5num_008"},
    [9] = {"g5num_009", "g5num_009"},
    [10] = {"g5num_010", "g5num_010"}
}

unit = {                                    -- Intonation down, intonation up
    ["MILE"] = {nil, nil},
    ["YARDS"] = {"g5unt_006--02","g5unt_006--02"},
    ["KILOMETER"] = {nil, nil},
    ["METERS"] = {"g5unt_002--002","g5unt_002--002"},
    ["METER"] = {nil, nil},
    ["KILOMETERS"] = {nil, nil},
    ["MILES"] = {nil, nil},
    ["nil"] = {nil, nil},
    ["UNDEFINED"] = {nil, nil}
}

misc = { 
    ["beep_sound"] = "beep",
    ["gps_signal_lost_wav"] = "g5war_011e",
    ["gps_signal_restored_wav"] = "g5war_010e",
    ["no_gps_signal_wav"] = "g5war_009e",
    ["route_recalculation_wav"] = "g5war_012e",
    ["now_wav"] = "g5mod_006",
    ["destination_wav"] = "g5ann_001",
    ["stopover_wav"] = "g5ann_002e",
    ["end_of_street_wav"] = "g5mod_004",
    ["follow_hwy_wav"] = "g5man_008e",
    ["follow_road_e_wav"] = "g5man_002ve",
    ["follow_road_wav"] = "g5man_002v",
    ["for_wav"] = "g5pre_002",
    ["roundabout_wav"] = "g5mod_005p",
    ["after_wav"] = "g5pre_003",
    ["after_junct_wav"] = "g5pre_003_01",
    ["and_wav"] = "g5con_001",
    ["one_km_wav"] = "g5unt_003",
    ["2_4km_wav"] = "g5unt_004",
    ["2_4km_wav_e"] = "g5unt_004e",
    ["5_0km_wav"] = "g5unt_004--01",
    ["5_0km_wav_e"] = "g5unt_004--01e",
    ["one_mile_wav"] = "g5unt_007--01",
    ["2_4miles_wav"] = "g5unt_008--02",
    ["2_4miles_wav_e"] = "g5unt_008--02e",
    ["5_0miles_wav"] = "g5unt_008--03",
    ["5_0miles_wav_e"] = "g5unt_008--03e",
    ["second_right_wav"] = "g5ext_013e",
    ["second_left_wav"] = "g5ext_014e",
    ["again_right_wav"] = "g5tur_003again_e",
    ["again_left_wav"] = "g5tul_003again_e",
    ["the_junction_wav"] = "g5mod_017",
    ["immediately_wav"] = "g5immediately_2",
    ["safety_camara_ahead_wav"] = "g5war_035e",
    ["over_speed_limit_wav"] = "g5war_speed_limit_soft4edit9",
    ["traffic_automatic_detour_wav"] = "g5war_018e",
    ["traffic_manual_detour_wav"] = "g5war_017e",
    ["and_then_wav"] = "g5con_001o"
}

right = { ["QUITE_RIGHT"] = 0, ["HEAVY_RIGHT"] = 0, ["LIGHT_RIGHT"] = 0, ["KEEP_RIGHT"] = 0 }
left = { ["QUITE_LEFT"] = 0, ["HEAVY_LEFT"] = 0, ["LIGHT_LEFT"] = 0, ["KEEP_LEFT"] = 0 }

check_files = { maneuver_turns, maneuver_check, exit_number_check, distances, unit, misc }
