-- ----------------------------------------------------------------------------
-- Copyright (C) 2011 Nokia Gate5 GmbH Berlin
--
-- These coded instructions, statements, and computer programs contain
-- unpublished proprietary information of Nokia Gate5 GmbH Berlin, and
-- are copy protected by law. They may not be disclosed to third parties
-- or copied or duplicated in any form, in whole or in part, without the
-- specific, prior written permission of Nokia Gate5 GmbH Berlin.
-- ----------------------------------------------------------------------------
--      Authors: RFS, Fabian TP Riek
-- ----------------------------------------------------------------------------
--             Voice Skin: Hindi TTS

description = "TTS"
gender = "f"
travel_mode = "0"    -- walk and drive 
output_type = "tts"
speaker = "Lekha"
language = "Hindi"
marc_code = "hin"
language_id = "58"
id = "58002"
config_file = "hindi_tts/config_tts.lua"
audio_files_path = "hindi_tts/hindi_tts"
rulesets_file = "hindi_tts/hindi_tts/rulesets_HII.txt"
--userdictionary_file = "hindi_tts/hindi_tts/udct_hii.dat"
apdb = "apdb/lekha/nm"
audio_files_version = "0.3.0.2012031601"
feature_list = { "metric", "imperial_uk", "" }
client_range = "[ client >= 1.4.6.0 ; client < 1.7.0.0 ]"

maneuver_check = {
    ["END"] = "आप अपने गंतव्य स्थान पर पहुँच जायेंगे",							-- You will reach your destination
    ["STOPOVER"] = "आप एक स्टॉपओवर पर पहुँचेंगे।",						-- You will reach a stopover
    ["JUNCTION"] = nil,                         -- No voice file needed -> check maneuver_turn
    ["PASS_JUNCTION"] = nil,                    -- the junction
    ["ROUNDABOUT"] = "गोलचक्कर पर",							  		-- At the roundabout
    ["EXIT_ROUNDABOUT"] = "बाहर निकलें",								-- take the exit
    ["UTURN"] = "यू-टर्न लें",										      --    Make a uturn
    ["ENTER_HIGHWAY"] = "हाइवे में प्रवेश करें",							-- enter the highway
    ["LEAVE_HIGHWAY"] = "बाहर निकलें",		  						-- take the exit
    ["CONTINUE_HIGHWAY"] = "हाइवे/राजमार्ग पर चलें ",						-- follow the highway
    ["ENTER_URBAN_HIGHWAY"] = "हाइवे में प्रवेश करें",						-- enter the urban highway
    ["LEAVE_URBAN_HIGHWAY"] = "निकास लें",                          -- take the exit
    ["CONTINUE_URBAN_HIGHWAY"] = "शहरी राजमार्ग पर चलें",					-- follow the urban highway
    ["DRIVE_TO_NEAREST_ROAD"] = "निकटतम सडक की ओर बढ़ें।",				-- drive to nearest road 
    ["FERRY"] = "नाव लें"											-- take the ferry
}

maneuver_turns_car = {
    ["NO_TURN"] = "सीधा जाएँ",				-- go straight ahead
    ["KEEP_MIDDLE"] = "बीच की लेन पर रहें",		-- keep the middle lane
    ["KEEP_RIGHT"] = "दाईं ओर रहें",			-- keep right
    ["LIGHT_RIGHT"] = "थोड़ा दाएँ मुड़ें",			-- turn slightly right
    ["QUITE_RIGHT"] = "दाएँ मुड़ें",			-- turn right
    ["HEAVY_RIGHT"] = "तीक्ष्ण दाएँ मुड़ें",		-- turn sharply right
    ["RETURN"] = "यू-टर्न लें",				-- make a u turn
    ["HEAVY_LEFT"] = "तीक्ष्ण बाएँ मुड़ें",			-- turn sharply left
    ["QUITE_LEFT"] = "बाएँ मुड़ें",				-- turn left
    ["LIGHT_LEFT"] = "थोड़ा बाएँ मुड़ें",			-- turn slightly left
    ["KEEP_LEFT"] = "बाईं ओर रहें",			-- keep left
    ["nil"] = nil,
    ["UNDEFINED"] = nil
}

maneuver_turns_pedestrian = {
    ["NO_TURN"] = "सीधे चलें",				-- walk straight ahead
    ["KEEP_MIDDLE"] = "बीच की सड़क पकड़ें",		-- take the street in the middle
    ["KEEP_RIGHT"] = "दाएँ ओर की सड़क पकड़ें ",	-- take the street on the right
    ["LIGHT_RIGHT"] = "थोड़ा दाएँ मुड़ें",			-- turn slightly right
    ["QUITE_RIGHT"] = "दाएँ मुड़ें",			-- turn right
    ["HEAVY_RIGHT"] = "तीक्ष्ण दाएँ मुड़ें",		-- turn sharply right
    ["RETURN"] = "यू-टर्न लें",				-- make a u turn ("return")
    ["HEAVY_LEFT"] = "तीक्ष्ण बाएँ मुड़ें",			-- turn sharply left
    ["QUITE_LEFT"] = "बाएँ मुड़ें",				-- turn left
    ["LIGHT_LEFT"] = "थोड़ा बाएँ मुड़ें",			-- turn slightly left
    ["KEEP_LEFT"] = "बाईं ओर की सड़क पकड़ें",		-- take the street on the left
    ["nil"] = nil,
    ["UNDEFINED"] = nil
}

pedestrian_vc = {
    ["BUILDING"] = "इमारत से जाएं",				-- go through the building
    ["SQUARE"] = "चौक पार करें",					-- cross the square
    ["PARK"] = "उद्यान पार करें",					-- cross the park
    ["STAIRS"] = "सीढ़ियों लें",					-- take the stairs
    ["ELEVATOR"] = "लिफ्ट लें",					-- take the elevator
    ["ESCALATOR"] = "एस्केलेटर लें"				-- take the escalator
}

final_command = {
    ["END"] = "आप अपने गंतव्य स्थान पर पहुँच चूके हैं ",		-- You have reached your destination
    ["STOPOVER"] = "आप एक स्टॉपओवर पर पहुँच गए हैं"     -- You have reached a stopover
}


exit_number_check = {
    [1] = {"पहला निकास लें", "पहले मार्ग पर मुड़ें"},				-- take the first exit / turn at the first street
    [2] = {"दूसरा निकास लें", "दूसरे मार्ग पर मुड़ें"},				-- take the second exit / turn at the second street
    [3] = {"तीसरा निकास लें", "तीसरे मार्ग पर मुड़ें"},				-- take the third exit / turn at the third street
    [4] = {"चौथा निकास लें", "चौथे मार्ग पर मुड़ें"},					-- take the fourth exit / turn at the fourth street
    [5] = {"पांचवां निकास लें", "पाँचवें मार्ग पर मुड़ें"},				-- take the fifth exit / turn at the fifth street
    [6] = {"छठा निकास लें", "छठे मार्ग पर मुड़ें"},					-- take the sixth exit / turn at the sixth street
    [7] = {"सातवाँ निकास लें", "सातवें मार्ग पर मुड़ें"},				-- take the seventh exit / turn at the seventh street
    [8] = {"आठवां निकास लें", "आठवें मार्ग पर मुड़ें"},				-- take the eighth exit / turn at the eighth street
    [9] = {"नौवां निकास लें", "नौवें मार्ग पर मुड़ें"},					-- take the ninth exit / turn at the ninth street
    [10] = {"दसवां निकास लें", "दसवें मार्ग पर मुड़ें"},				-- take the tenth exit / turn at the tenth street
    [11] = {"ग्यारहवां निकास लें", "ग्यारहवें मार्ग पर मुड़ें"},				-- take the eleventh exit / turn at the eleventh street
    [12] = {"बारहवां निकास लें", "बारहवें मार्ग पर मुड़ें"}				-- take the twelfth exit / turn at the twelfth street
}

unit = {                        
    ["MILE"] = "मील",			-- mile
    ["YARDS"] = "गज",			-- yards
    ["FEET"] = "फीट",				-- feet
    ["KILOMETER"] = "किलोमीटर",	-- kilometer
    ["METERS"] = "मीटर",			-- meters
    ["METER"] = "मीटर",			-- meter
    ["KILOMETERS"] = "किलोमीटर",	-- kilometers
    ["MILES"] = "मील",			-- miles
    ["nil"] = nil,
    ["UNDEFINED"] = nil
}

orientation = {
    ["NORTH"] = "उत्तर",			-- north	("उत्तर में बढ़ें" = head north)
    ["NORTH_EAST"] = "उत्तर पूर्व",	-- northeast ("उत्तर पूर्व में बढ़ें" = head northeast)
    ["EAST"] = "पूर्व",				-- east		("पूर्व में बढ़ें" = head east)
    ["SOUTH_EAST"] = "दक्षिण पूर्व",	-- southeast ("दक्षिण पूर्व में बढ़ें" = head southeast)
    ["SOUTH"] = "दक्षिण",			-- south	("दक्षिण में बढ़ें" = head south)
    ["SOUTH_WEST"] = "दक्षिण पश्चिम",	-- southwest ("दक्षिण पश्चिम में बढ़ें" = head southwest)
    ["WEST"] = "पश्चिम",			-- west		("पश्चिम में बढ़ें" = head west)
    ["NORTH_WEST"] = "पश्चिमोत्तर"	-- northwest ("पश्चिमोत्तर में बढ़ें" = head northwest)
}

misc = { 
    ["gps_signal_lost_wav"] = "जीपीएस सिग्नल खो गया है",								-- GPS signal lost
    ["gps_signal_restored_wav"] = "जीपीएस सिग्नल लौट चुका है",							-- GPS signal has been restored
 --   ["no_gps_signal_wav"] = "जीपीएस सिग्नल उपलब्ध नहीं हें",							-- No GPS signal
    ["route_recalculation_wav"] = "रास्ते की पूणः गणना ",							-- Route recalculation
    ["now_wav"] = "अब",														-- now
    ["end_of_street_wav"] = "सड़क के अंत पर",										-- At the end of the road ("पर" = at)
    ["follow_motorway_wav"] = "हाइवे पर बढ़ते रहें।",										-- Follow the highway
    ["follow_road_wav"] = "इसी सड़क पर बढ़ते रहें।",										-- Follow the course of the road
    ["for_wav"] = "तक",													-- for
    ["after_wav"] = "के बाद",													-- after
    ["the_junction_wav"] = "चौराहे",											-- the junction ("चौराहे के बाद <command>" = after the junction...)
    ["half_a_mile_wav"] = "आधा मील",											-- half a mile
    ["quarter_a_mile_wav"] = "एक चौथाई मील",										-- a quarter of a mile
    ["three_quarter_of_mile_wav"] = "तीन चौथाई मील",								-- three quarters of a mile
    ["immediately_wav"] = "तुरंत",												-- immediately
    ["safety_camara_ahead_wav"] = "आगे सुरक्षा कैमरा है",								-- Safety camera ahead
    --["over_speed_limit_wav"] = "गति सीमा का पालन करें",								-- Observe speed limit
    ["traffic_automatic_detour_wav"] = "रास्ते पर ट्रैफिक हें, चक्करदार मार्ग की खोज जारी है",		-- Traffic on route, detouring
    ["traffic_manual_detour_wav"] = "रास्ते पर ट्रैफिक हें, क्या आप मार्ग लेना चाहेंगे?",			-- Traffic on route, do you want to detour?
    ["no_detour_possible"] = "ट्रैफ़िक के चारों ओर कोई मार्ग नहीं मिला हें",						-- No detour found around traffic
    ["and_wav"] = "और",														-- and
    ["and_then_wav"] = "और फिर",												-- and then
    ["continue_on_wav"] = "पर बढ़ते रहें।",											-- and continue on
    ["towards_wav"] = "की ओर",												-- towards ("... Berlin की ओर" = ... towards Berlin)
    ["turn_wav"] = "मुड़ें",														-- turn
    ["onto_wav"] = "पर",														-- onto
    ["exit_wav"] = "निकास लें",													-- take exit ( "2B निकास लें" = take exit 2B)
    ["second_right_wav"] = "दूसरा दायां मोड़ लें",										-- take the second right
    ["second_left_wav"] = "दूसरा बायां मोड़ लें",										-- take the second left
    ["dot"] = ".",															-- "." for numbers like 2.5 (--> dot at the end of sentences is "।")
    ["walk_left_roundabout_wav"] = "गोलचक्कर पर बाएँ चलें",							-- walk left around the traffic circle
    ["walk_right_roundabout_wav"] = "गोलचक्कर पर दाएँ चलें",							-- walk right around the traffic circle
    ["walk_roundabout_wav"] = "गोलचक्कर पर कर चलें",								-- walk around the traffic circle
    ["head_wav"] = "में बढ़ें",													-- head "towards" (north, south, east, west, southeast...)
    ["pause"] = "\\pause=50\\",				
    ["on_wav"] = "पर",														-- on
    ["the_footpath_wav"] = "पगडंडी "											-- the footpath
}

wav_files = { 
    ["beep_sound"] = "beep16K.wav",
	["speed_limit_beeps"] = "g5war_speed_limit_soft4edit9.wav"       
}

right = { ["QUITE_RIGHT"] = 0, ["HEAVY_RIGHT"] = 0, ["LIGHT_RIGHT"] = 0, ["KEEP_RIGHT"] = 0 }
left = { ["QUITE_LEFT"] = 0, ["HEAVY_LEFT"] = 0, ["LIGHT_LEFT"] = 0, ["KEEP_LEFT"] = 0 }
keep = { ["KEEP_LEFT"] = 0, ["KEEP_RIGHT"] = 0, ["KEEP_MIDDLE"] = 0 }
highway = { ["ENTER_HIGHWAY"] = 0, ["ENTER_URBAN_HIGHWAY"] = 0, ["LEAVE_HIGHWAY"] = 0, ["LEAVE_URBAN_HIGHWAY"] = 0 }


