-- ----------------------------------------------------------------------------
-- Copyright (C) 2009 Nokia Gate5 GmbH Berlin
--
-- These coded instructions, statements, and computer programs contain
-- unpublished proprietary information of Nokia Gate5 GmbH Berlin, and
-- are copy protected by law. They may not be disclosed to third parties
-- or copied or duplicated in any form, in whole or in part, without the
-- specific, prior written permission of Nokia Gate5 GmbH Berlin.
-- ----------------------------------------------------------------------------
--      Authors: RFS
-- ----------------------------------------------------------------------------
--             Voice Skin: Hindi TTS

require("common_tts")

function get_voicefiles( )
end

function get_text_output( )
    get_common_code( )
end

function process_pedestrian_triggers( firstManeuver, secondManeuver )

    if trigger == "PEDESTRIAN_ANNOUNCEMENT" then
        process_pedestrian_announcement( firstManeuver, secondManeuver )
    elseif trigger == "PEDESTRIAN_COMMAND" then
        process_pedestrian_final_command( firstManeuver, secondManeuver )
    end
    
end

function process_head_to_command( firstManeuver )
    
    if firstManeuver.heading_orientation ~= nil and firstManeuver.heading_orientation ~= "" then
        
        if gps_location.street_label ~= nil and gps_location.street_label ~= "" then
            add_address_result( { gps_location.street_label, misc[ "on_wav" ] } )
        end
        if firstManeuver.extra_string ~= nil and firstManeuver.extra_string ~= "" 
            and firstManeuver.extra_string ~= gps_location.street_label then
            add_address_result( { firstManeuver.extra_string, misc[ "towards_wav" ] } )
        elseif firstManeuver.next_street ~= nil 
          and firstManeuver.next_street ~= "" 
          and firstManeuver.next_street ~= gps_location.street_label 
          and pedestrian_vc [ firstManeuver.next_street ] == nil 
          then
            add_address_result( { firstManeuver.next_street, misc[ "towards_wav" ] } )
        elseif firstManeuver.next_route ~= nil
         and firstManeuver.next_route ~= "" 
         and firstManeuver.next_route ~= firstManeuver.route 
         and pedestrian_vc [ firstManeuver.next_street ] == nil then
            add_address_result( { firstManeuver.next_route, misc[ "towards_wav" ] } )
        end
        
        add_address_result( { orientation[ firstManeuver.heading_orientation ], misc[ "head_wav" ] } )
    end
    
end

function process_pedestrian_announcement( firstManeuver, secondManeuver )
    if firstManeuver.id == "HEAD_TO" then
        process_head_to_command( firstManeuver )
    else
        include_distance( firstManeuver, "pedestrian" )
        add_pedestrian_maneuvers_to_table( firstManeuver, secondManeuver )
    end
end

function process_pedestrian_final_command( firstManeuver, secondManeuver )
    
    if firstManeuver.id == "HEAD_TO" then
        process_head_to_command( firstManeuver )
        return
    end
    
    if firstManeuver.id ~= "END" 
      and firstManeuver.id ~= "STOPOVER" then
        add_result( misc[ "now_wav" ] ) 
    end
    
    if firstManeuver.id == "END" 
      or firstManeuver.id == "STOPOVER" then
        add_result( final_command[ firstManeuver.id ] ) 
    else
        add_pedestrian_maneuvers_to_table( firstManeuver, secondManeuver )
    end
    
end

function add_pedestrian_vc_or_junction( firstManeuver )
    
    if pedestrian_vc[ firstManeuver.next_street ] == nil then
        -- JUNCTIONS
        if keep[ firstManeuver.turn ] == nil then   -- add "onto" only if maneuver doesn't belong to "keep"  	
            if firstManeuver.next_street ~= "" and firstManeuver.next_street ~= nil then
                if firstManeuver.next_street == gps_location.street_label then
                    add_address_result( { misc[ "and_wav" ], firstManeuver.next_street, misc[ "continue_on_wav" ] } )
                else
                    add_address_result( { firstManeuver.next_street, misc[ "onto_wav" ] } )
                end
            elseif firstManeuver.next_route ~= "" and firstManeuver.next_route ~= nil then
                if firstManeuver.next_route == gps_location.street_label then
                    add_address_result( { misc[ "and_wav" ], firstManeuver.next_route, misc[ "continue_on_wav" ] } )
                else
                    add_address_result( { firstManeuver.next_route, misc[ "onto_wav" ] } )
                end
            elseif firstManeuver.next_street_is_walkway == 1 and firstManeuver.street_is_walkway == 0 then
                add_address_result( { misc[ "the_footpath_wav" ], misc[ "onto_wav" ] } )
            end
        elseif double_command == false and firstManeuver.next_street ~= nil and firstManeuver.next_street ~= "" then
            add_address_result( firstManeuver.next_street )
        end
    -- VIRTUAL CONNECTIONS
    elseif pedestrian_vc[ firstManeuver.next_street ] ~= pedestrian_vc[ firstManeuver.street ] then
        if junction_turn ~= nil then
            add_result( misc[ "and_wav" ] )
        end
        -- add Virtual Connection action
        add_result( pedestrian_vc[ firstManeuver.next_street ] )
    end
        
end

function add_pedestrian_maneuvers_to_table( firstManeuver, secondManeuver )
    
    junction_turn, maneuver_command = get_maneuver( "pedestrian", firstManeuver )

    if firstManeuver.id == "END" 
     or firstManeuver.id == "STOPOVER" 
     or firstManeuver.id == "UTURN" 
     or firstManeuver.id == "FERRY" then
        add_result( maneuver_command )
    elseif firstManeuver.id == "EXIT_ROUNDABOUT" then
        exiting_roundabout_pedestrian( firstManeuver )
    elseif firstManeuver.id == "ROUNDABOUT" then
        roundabout_pedestrian( firstManeuver )
    else
        add_result( junction_turn )
        add_pedestrian_vc_or_junction( firstManeuver )
    end

    if double_command == true and firstManeuver.id ~= "ROUNDABOUT" then
        
        junction_turn, maneuver_command = get_maneuver( "pedestrian", secondManeuver )
        add_result( misc[ "and_then_wav" ] )
        include_distance ( secondManeuver, "pedestrian" )
        if secondManeuver.id == "ROUNDABOUT" then
            roundabout_pedestrian( secondManeuver )
        elseif junction_turn ~= nil then 
           add_result( junction_turn )
        else
           add_result( maneuver_command )
        end        
    end
    
end

function roundabout_pedestrian( maneuver )

    if maneuver.turn == "QUITE_RIGHT" then
        add_result( misc[ "walk_right_roundabout_wav" ] )
    elseif maneuver.turn == "QUITE_LEFT" then
        add_result( misc[ "walk_left_roundabout_wav" ] )
    else
        add_result( misc[ "walk_roundabout_wav" ] )
    end
    
    -- ANNOUNCEMENTS AND REMINDERS don't include exit information
    if trigger == "PEDESTRIAN_COMMAND" then
        if maneuver == maneuver_1 then
            
            add_result( misc[ "and_wav" ] )
            
            if maneuver.next_street ~= nil and maneuver.next_street ~= "" then
        	    add_address_result( maneuver.next_street )
        	  elseif maneuver.next_route ~= nil and maneuver.next_route ~= "" then
        	    add_address_result( maneuver.next_route )
    	      end 
    	      
            -- if exit number >=  4 don't give exit number
            if maneuver.extra_integer < 4 then 
                exit_roundabout = exit_number_check[ maneuver.extra_integer ] [ 2 ]
                add_result( exit_roundabout )
            elseif ( maneuver.next_street ~= nil and maneuver.next_street ~= "" )
                or ( maneuver.next_route ~= nil and maneuver.next_route ~= "" ) then
                add_result( { misc[ "onto_wav" ], misc[ "turn_wav" ] } )
            end
         
        end
    end
end

function exiting_roundabout_pedestrian( firstManeuver )
		
		if firstManeuver.next_street_is_walkway == 1 
      and ( firstManeuver.next_street == "" or firstManeuver.next_street == nil ) then
        add_result( { misc[ "the_footpath_wav" ], misc[ "onto_wav" ] } )
    elseif firstManeuver.next_street ~= nil and firstManeuver.next_street ~= "" then
        add_address_result( { firstManeuver.next_street, misc[ "onto_wav" ] } )
    end
    
    if firstManeuver.turn == "QUITE_RIGHT" then
        add_result( maneuver_turns_pedestrian[ "QUITE_RIGHT" ] )
    elseif firstManeuver.turn == "QUITE_LEFT" then
        add_result( maneuver_turns_pedestrian[ "QUITE_LEFT" ] )
    else
        add_result( misc[ "turn_wav" ] )
    end

end

function roundabout_car( maneuver )

    exit_roundabout_car = exit_number_check[ maneuver.extra_integer ] [1]
    add_result( exit_roundabout_car )

end 

function process_car_triggers( firstManeuver, secondManeuver, useSignpost, useSignpostNext  )

    if trigger == "COMMAND" then   
        process_car_final_command( firstManeuver, secondManeuver, useSignpost, useSignpostNext )
    elseif trigger == "REMINDER1" or trigger == "REMINDER2" then
        process_car_reminders( firstManeuver, secondManeuver, useSignpost, useSignpostNext )
    elseif trigger == "ANNOUNCEMENT" then   
        process_car_announcement( firstManeuver, secondManeuver, useSignpost, useSignpostNext )
    end
    
end

function process_car_final_command( firstManeuver, secondManeuver, useSignpost, useSignpostNext )

    if firstManeuver.id ~= "END" 
    and firstManeuver.id ~= "ROUNDABOUT" 
    and firstManeuver.id ~= "STOPOVER" 
    and firstManeuver.id ~= "DRIVE_TO_NEAREST_ROAD"
    and firstManeuver.id ~= "PASS_JUNCTION" then
        -- "now"
        add_result( misc[ "now_wav" ] )
    end
    
    if firstManeuver.id == "END" 
      or firstManeuver.id == "STOPOVER" then
        add_result( final_command[ firstManeuver.id ] )
    else
        if firstManeuver.id == "PASS_JUNCTION" then
            add_result( { misc[ "the_junction_wav" ], misc[ "after_wav" ] } )
        end
        add_car_maneuver_to_table( firstManeuver, secondManeuver, useSignpost, useSignpostNext )
    end

end

function process_car_reminders( firstManeuver, secondManeuver, useSignpost, useSignpostNext )

    -- If maneuver is "at the end of the street"
    if firstManeuver.extra_string == "EOS" and trigger == "REMINDER1" then
        add_result( misc[ "end_of_street_wav" ] )
    else
        include_distance( firstManeuver, "car" )
    end
    add_car_maneuver_to_table( firstManeuver, secondManeuver, useSignpost, useSignpostNext )
    
end


function process_car_announcement( firstManeuver, secondManeuver, useSignpost, useSignpostNext )
    
    if road_class == "HIGHWAY" and ( ( firstManeuver.dist_to >= 10000 and firstManeuver.dist_unit == "KILOMETERS" ) or ( firstManeuver.dist_to >= 16000 and firstManeuver.dist_unit == "MILES" ) )then
        -- i.e.: "follow A2 Autopista del Mediterraneo for X km/miles"
        
        add_result( { firstManeuver.dist_to_unit, unit[ firstManeuver.dist_unit ], misc[ "for_wav" ] } )
        
        if ( gps_location.fow == "SLIPROAD" )then
            add_address_result( { firstManeuver.route, misc[ "follow_motorway_wav" ] } )
        elseif ( gps_location.fow == "MOTORWAY"  )then
                add_address_result( { gps_location.route, misc[ "follow_motorway_wav" ]  } )
        else
            add_address_result( { gps_location.street_label, misc[ "follow_motorway_wav" ] } )
        end
        
    elseif road_class == "STREET" and firstManeuver.dist_to >= 3000 then
        -- i.e.: "follow Oxford Street for X km/miles"
        add_result( { firstManeuver.dist_to_unit, unit[ firstManeuver.dist_unit ], misc[ "for_wav" ], misc[ "follow_road_wav" ] } )
    else
        include_distance( firstManeuver, "car" )
        add_car_maneuver_to_table( firstManeuver, secondManeuver, useSignpost, useSignpostNext )
    end
    
end

function get_maneuver( mode, maneuver )
    
    if mode == "car" then
        maneuver_turns = maneuver_turns_car
    else 
        maneuver_turns = maneuver_turns_pedestrian
    end

    if maneuver ~= nil then
        junction_turn = maneuver_turns[ maneuver.turn ]
        maneuver_command = maneuver_check[ maneuver.id ]
    end

    return junction_turn, maneuver_command
end

function include_distance( maneuver, mode )
    
    if maneuver ~= nil and maneuver.dist_to_unit ~= "0" then        
        
        if maneuver.dist_to_unit == "0.50" and maneuver.dist_unit == "MILE" then
            add_result( misc[ "half_a_mile_wav" ] )
        elseif maneuver.dist_to_unit == "0.25" and maneuver.dist_unit == "MILE" then
            add_result( misc[ "quarter_a_mile_wav" ] )
        elseif maneuver.dist_to_unit == "0.75" and maneuver.dist_unit == "MILE" then
            add_result( misc[ "three_quarter_of_mile_wav" ] )
        else
            -- insert distance to maneuver + unit to maneuver
            add_result( {  maneuver.dist_to_unit, unit[ maneuver.dist_unit ] } )
        end
        
        add_result( misc[ "after_wav" ] )
             
    end
    
end

function insert_signpost_enter_hwy( firstManeuver, useSignpost )

    if useSignpost == true then
        if firstManeuver.signpost_direction ~= "" then
            add_address_result( { firstManeuver.signpost_direction, misc[ "towards_wav" ] } )
        end
        if firstManeuver.next_route ~= "" then
            add_address_result( firstManeuver.next_route ) 
        elseif firstManeuver.next_street ~= "" then
            add_address_result( firstManeuver.next_street ) 
        end
    end

end

function insert_signpost_leave_or_continue_hwy( firstManeuver, secondManeuver, useSignpost, useSignpostNext )   -- Also valid for junctions on hwy

    if ( firstManeuver.signpost_exit_number ~= "" or firstManeuver.signpost_exit_name ~= "" ) and useSignpost == true  then
        
        if double_command == false then
        
            if ( firstManeuver.next_route ~= "" and firstManeuver.next_route ~= nil ) or (firstManeuver.signpost_direction ~= nil and firstManeuver.signpost_direction ~= "" ) then
                if ( firstManeuver.route ~= firstManeuver.next_route ) and ( firstManeuver.next_route ~= nil and firstManeuver.next_route ~= "" ) then
                    add_address_result( { firstManeuver.next_route, firstManeuver.signpost_direction, misc[ "towards_wav" ] } )
                elseif ( firstManeuver.route == firstManeuver.next_route ) and ( firstManeuver.next_route ~= "" and firstManeuver.next_route ~= nil )then
                    add_address_result( { misc[ "and_wav" ], firstManeuver.next_route, misc[ "continue_on_wav" ] } )
                    if firstManeuver.signpost_direction ~= "" and firstManeuver.signpost_direction ~= nil and firstManeuver.signpost_direction ~= firstManeuver.signpost_exit_name then
                        add_address_result( { firstManeuver.signpost_direction, misc[ "towards_wav" ] } ) 
                    end
                elseif firstManeuver.signpost_direction ~= "" and firstManeuver.signpost_direction ~= nil and firstManeuver.signpost_direction ~= firstManeuver.signpost_exit_name then
                    add_address_result( { firstManeuver.signpost_direction, misc[ "towards_wav" ] } ) 
                end
            end
        
        -- double command == true    
        else
            second_command_leave_or_continue_hwy( secondManeuver )
            
            if ( secondManeuver.signpost_direction == "" or secondManeuver.signpost_direction == nil ) 
              and ( secondManeuver.id ~= "END" and secondManeuver.id ~= "STOPOVER" ) then
                add_address_result( { secondManeuver.next_route, firstManeuver.signpost_direction, misc[ "towards_wav" ] } ) 
            elseif ( secondManeuver.signpost_direction ~= "" and secondManeuver.signpost_direction ~= nil ) 
              or ( secondManeuver.next_route ~= "" and secondManeuver.next_route ~= nil ) then
                add_address_result( { secondManeuver.next_route, secondManeuver.signpost_direction, misc[ "towards_wav" ] } ) 
            end
        end
        
        add_address_result( { firstManeuver.signpost_exit_number } ) 
        if ( firstManeuver.signpost_exit_name ~= "" and firstManeuver.signpost_exit_name ~= nil ) then 
            add_address_result ( { misc[ "pause" ], firstManeuver.signpost_exit_name  } )
        end
        add_result( misc[ "exit_wav" ] ) 
        
    elseif ( firstManeuver.signpost_direction ~= "" and firstManeuver.signpost_direction ~= nil ) and useSignpost == true then
        add_address_result( { firstManeuver.next_route, firstManeuver.signpost_direction, misc[ "towards_wav" ] } ) 
        if double_command == true then
            second_command_leave_or_continue_hwy( secondManeuver )
        end
        
    else
        if double_command == false and firstManeuver.id == "LEAVE_HIGHWAY" then
            if junction_turn ~= nil then
                add_result( misc[ "and_wav" ] ) 
            end
            add_result( maneuver_check[ "LEAVE_HIGHWAY" ] )
        elseif double_command == true then
            if firstManeuver.id == "LEAVE_HIGHWAY" then
                add_result( maneuver_check[ "LEAVE_HIGHWAY" ] ) 
            end
            second_command_leave_or_continue_hwy( secondManeuver )
        end
    end

end

function second_command_leave_or_continue_hwy( maneuver )
    
    junction_turn, maneuver_command = get_maneuver( "car", maneuver )
    add_result( misc[ "and_then_wav" ] ) 
    if maneuver.id == "ROUNDABOUT" then
        add_result( maneuver_command )
        roundabout_car( maneuver )         
    else
        if junction_turn ~= nil then
            maneuver_command = nil
        end
        add_result( { junction_turn, maneuver_command } ) 
    end 

end

function insert_signpost_roundabout( firstManeuver, useSignpost )

    if useSignpost == true then
        if firstManeuver.signpost_direction ~= "" and firstManeuver.signpost_direction ~= nil then
            add_address_result( { firstManeuver.signpost_direction, misc[ "towards_wav" ] } )
        elseif firstManeuver.next_street ~= "" and firstManeuver.next_street ~= nil then  
            add_address_result( { firstManeuver.next_street, misc[ "onto_wav" ] } )
        elseif firstManeuver.next_route ~= "" and firstManeuver.next_route ~= nil then
            add_address_result( { firstManeuver.next_route, misc[ "onto_wav" ] } )
        end
    end

end

function check_take_second_road( maneuver )

    if right[ maneuver.turn ] ~= nil and maneuver.exits_right == 1 then
        -- take the second right
        junction_turn = misc[ "second_right_wav" ]
        maneuver_command = nil
    elseif left[ maneuver.turn ] ~= nil and maneuver.exits_left == 1 then
        -- take the second left
        junction_turn = misc[ "second_left_wav" ]
        maneuver_command = nil
    end
         
end

function add_street_name_or_route( maneuver, useSignpost )

    if useSignpost == true or maneuver.id == "EXIT_ROUNDABOUT" then
        if maneuver.id == "END" or maneuver.id == "STOPOVER" then
            if ( maneuver.street ~= "" and maneuver.street ~= nil ) then
                add_address_result( { maneuver.street, misc[ "on_wav" ] } ) 
            elseif ( maneuver.route ~= "" and maneuver.route ~= nil ) then
                add_address_result( { maneuver.route, misc[ "on_wav" ] } ) 
            end
        elseif road_class == "HIGHWAY" and ( maneuver.signpost_direction ~= "" and maneuver.signpost_direction ~= nil ) then
            add_address_result( { maneuver.signpost_direction, misc[ "towards_wav" ] } )
        elseif road_class == "STREET" then
            if ( maneuver.signpost_direction ~= "" and maneuver.signpost_direction ~= nil ) then
                add_address_result( { maneuver.signpost_direction, misc[ "towards_wav" ] } )
            elseif ( maneuver.next_street ~= "" and maneuver.next_street ~= nil ) then
                add_address_result( { maneuver.next_street, misc[ "onto_wav" ] } )
            elseif ( maneuver.next_route ~= "" and maneuver.next_route ~= nil ) then
                add_address_result( { maneuver.next_route, misc[ "onto_wav" ] } )
            end
        end
    end
    
end

function add_car_maneuver_to_table( firstManeuver, secondManeuver, useSignpost, useSignpostNext  )   
    
    junction_turn, maneuver_command = get_maneuver( "car", firstManeuver )
        
    if firstManeuver.id == "ENTER_HIGHWAY" or firstManeuver.id == "ENTER_URBAN_HIGHWAY" then
        add_result( junction_turn )
        if double_command == false and junction_turn ~= nil then
            add_result( misc[ "and_then_wav" ] )
        end 
        insert_signpost_enter_hwy( firstManeuver, useSignpost )
        add_result( maneuver_command )
    
    elseif firstManeuver.id == "END" 
     or firstManeuver.id == "STOPOVER" then       
        add_street_name_or_route( firstManeuver, useSignpost )
        add_result( maneuver_command ) 
        
    elseif firstManeuver.id == "DRIVE_TO_NEAREST_ROAD"
     or firstManeuver.id == "FERRY" 
     or firstManeuver.id == "EXIT_ROUNDABOUT" then
        if double_command == false then
            add_street_name_or_route( firstManeuver, useSignpost )
        end
        add_result( maneuver_command )
        
    elseif firstManeuver.id == "ROUNDABOUT" then
        insert_signpost_roundabout( firstManeuver, useSignpost )
        add_result( maneuver_command )
        roundabout_car( firstManeuver )         
        
        
    elseif firstManeuver.id == "UTURN" then
        add_result( maneuver_command )
        
    elseif road_class == "HIGHWAY" then
        add_result( junction_turn )
        insert_signpost_leave_or_continue_hwy( firstManeuver, secondManeuver, useSignpost, useSignpostNext ) 
        
    else
        add_street_name_or_route( firstManeuver, useSignpost )
        add_result( junction_turn )    

    end

    if double_command == true 
        and road_class ~= "HIGHWAY" then
             
        junction_turn, maneuver_command = get_maneuver( "car", secondManeuver )
        add_result( misc[ "and_then_wav" ] )  
        
        if secondManeuver.dist_to <= 30 
        and secondManeuver.id ~= "END" 
        and secondManeuver.id ~= "ROUNDABOUT" 
        and secondManeuver.id ~= "STOPOVER" then  
            add_result( misc[ "immediately_wav" ] )  
        end
        
        if secondManeuver.id == "ENTER_HIGHWAY" or secondManeuver.id == "ENTER_URBAN_HIGHWAY" then
            insert_signpost_enter_hwy( secondManeuver, useSignpostNext )
        else
            add_street_name_or_route( secondManeuver, useSignpostNext )
        end

        if secondManeuver.id == "JUNCTION" then    
            check_take_second_road( secondManeuver )  
            add_result( junction_turn )
        else
            -- if second maneuver = enter/change hwy, then read only the junction attribute 
            if highway[ secondManeuver.id ] ~= nil then 
                if secondManeuver.turn ~= nil and secondManeuver.turn ~= "UNDEFINED" then
                    maneuver_command = nil
                end
            elseif secondManeuver.id == "ROUNDABOUT" or secondManeuver.id == "EXIT_ROUNDABOUT" then
                junction_turn = nil
            end
            add_result( { junction_turn, maneuver_command } )  
            if secondManeuver.id == "ROUNDABOUT" then
                roundabout_car( secondManeuver )        
            end
        end
        
    end
end
