-- ----------------------------------------------------------------------------
-- Copyright (C) 2009 Nokia Gate5 GmbH Berlin
--
-- These coded instructions, statements, and computer programs contain
-- unpublished proprietary information of Nokia Gate5 GmbH Berlin, and
-- are copy protected by law. They may not be disclosed to third parties
-- or copied or duplicated in any form, in whole or in part, without the
-- specific, prior written permission of Nokia Gate5 GmbH Berlin.
-- ----------------------------------------------------------------------------
--      Authors: Raul Ferrandez Salvador
-- ----------------------------------------------------------------------------

engine_mode = nil

function get_common_code( )
    
    if maneuver_1 ~= nil then
        maneuver = maneuver_1   -- Default values
        maneuver.dist_to_unit = maneuver.dist_to_unit_string
    end

    if maneuver_2 ~= nil then
        nextManeuver = maneuver_2
        nextManeuver.dist_to_unit = nextManeuver.dist_to_unit_string
    end
    
    engine_mode = nil
    is_double_command()
    dgttsp_rules()
    
    -- GPS triggers
    if trigger == "GPS_SIGNAL_LOST" or trigger == "GPS_SIGNAL_RESTORED" or trigger == "ROUTE_RECALCULATION" then
        process_gps_triggers()
        
    -- Maneuver triggers
    elseif ( trigger == "REMINDER1" or trigger == "REMINDER2" or trigger =="ANNOUNCEMENT" ) 
        and maneuver.dist_to_unit ~= nil and maneuver.dist_to_unit ~= "0"  and  maneuver.dist_unit ~= "UNDEFINED"  then
    	process_car_triggers( maneuver, nextManeuver, use_dgttsp_0, use_dgttsp_1 )
    
    elseif  trigger == "COMMAND" then
        process_car_triggers( maneuver, nextManeuver, use_dgttsp_0, use_dgttsp_1 )
        
    -- Safety SpotWarner 
    elseif trigger == "SAFETYSPOT_WARNER" then
        add_wav_file ( wav_files[ "beep_sound" ] )
        if above_speed_limit == true then
            table.insert(result_list, misc[ "safety_camara_ahead_wav" ] )
        end  
          
    -- Speed Warners triggers. Updated with beeps
    elseif trigger == "SPEED_WARNER" then
        add_wav_file ( wav_files[ "speed_limit_beeps" ] )
    -- Traffic Warner
    elseif trigger == "TRAFFIC_WARNER" then
        if avoidance_mode == "AUTOMATIC_AVOIDANCE" then
            table.insert(result_list, misc[ "traffic_automatic_detour_wav" ] )
        elseif avoidance_mode == "MANUAL_AVOIDANCE" then
            table.insert(result_list, misc[ "traffic_manual_detour_wav" ] )
        end

    -- Traffic detour failed
    elseif trigger == "TRAFFIC_DETOUR_FAILED" then
        table.insert(result_list, misc[ "no_detour_possible" ] )
        
    -- Pedestrian announcement
    elseif trigger == "PEDESTRIAN_ANNOUNCEMENT" 
        and maneuver.dist_to_unit ~= nil and maneuver.dist_to_unit ~= "0"  and  maneuver.dist_unit ~= "UNDEFINED"  then
        process_pedestrian_triggers( maneuver, nextManeuver )
        
    -- Pedestrian command
    elseif trigger == "PEDESTRIAN_COMMAND"  then
        process_pedestrian_triggers( maneuver, nextManeuver )
    end
    
    -- Add "." at the end of last element from table "result_list", if it is not empty
    -- NOTE: The length operator is denoted by the unary operator #
    if #result_list > 0 then
    	result_list[#result_list] = result_list[#result_list] .. misc[ "dot" ]
    end

end

function process_gps_triggers()

    if guidance_mode ~= "pedestrian" then
        if trigger == "GPS_SIGNAL_LOST" then
            -- "GPS signal lost"
            table.insert( result_list, misc[ "gps_signal_lost_wav" ]) 
        end
        if trigger == "GPS_SIGNAL_RESTORED" then
            -- "GPS connection has been restored"
            table.insert( result_list, misc[ "gps_signal_restored_wav" ] )
        end
    end

 --   if trigger == "NO_GPS_SIGNAL" then
        -- "No GPS signal"
 --       table.insert( result_list, misc[ "no_gps_signal_wav" ] )
 --   end

    if trigger == "ROUTE_RECALCULATION" then
        -- "Route recalculation"
        table.insert( result_list, misc[ "route_recalculation_wav" ] )
    end
end

function is_double_command()
    
    double_command = false
    if ( maneuver_set_count == 2 ) then
        double_command = true
    end
    
end

function dgttsp_rules()
--------------------------------------------------------------------------
-- Rules when to use DGTTSP (dynamically generated TTS prompts)
--------------------------------------------------------------------------
    
    -- Non Highway
    if road_class == "STREET" then
        
        if ( trigger == "ANNOUNCEMENT" and maneuver_1.dist_to <= 500 ) or trigger == "REMINDER1" then
            use_dgttsp_0 = true
            use_dgttsp_1 = false
        elseif trigger == "COMMAND" and double_command == true  then 
            use_dgttsp_0 = false
            use_dgttsp_1 = true
        else
            use_dgttsp_0 = false
            use_dgttsp_1 = false
        end
        
    -- Highway
    else
        
        if ( trigger == "ANNOUNCEMENT" and  maneuver_1.dist_to <= 650  ) or trigger == "REMINDER1" then
            use_dgttsp_0 = true
            use_dgttsp_1 = false

        elseif trigger == "COMMAND" and double_command == true then
            use_dgttsp_0 = false
            use_dgttsp_1 = true
        else
            use_dgttsp_0 = false
            use_dgttsp_1 = false
        end
        
    end
end

function  internal_add_result( result )
    -- Add result to the list    
    if type( result ) == "table" then
        for j,t in pairs( result ) do
            table.insert( result_list, t )
        end
    else
        table.insert( result_list, result )
    end
end

function internal_set_engine_mode( mode )
    if engine_mode ~= mode then
            table.insert( result_list, "\\tn=" .. mode .. "\\" )
            engine_mode = mode
    end 
end

function add_result( result )
    if result ~= nil then
        internal_set_engine_mode( "normal" )
        internal_add_result( result )
    end
end

function add_address_result( result )
    if result ~= nil then
        internal_set_engine_mode( "address" )
        internal_add_result( result )
    end
end

function add_wav_file ( file )
    if file ~= nil then
        table.insert( result_list, '\\audio="' .. audio_files_path_absolute .. "\/" .. file .. '"\\' )
    end
end
    
    
