-- ----------------------------------------------------------------------------
-- Copyright (C) 2012 Nokia Gate5 GmbH Berlin
--
-- These coded instructions, statements, and computer programs contain
-- unpublished proprietary information of Nokia Gate5 GmbH Berlin, and
-- are copy protected by law. They may not be disclosed to third parties
-- or copied or duplicated in any form, in whole or in part, without the
-- specific, prior written permission of Nokia Gate5 GmbH Berlin.
-- ----------------------------------------------------------------------------
--      Authors: RFS, Fabian TP Riek
-- ----------------------------------------------------------------------------
--             Voice Skin: Spanish TTS

description = "TTS"
gender = "f"
travel_mode = "0"    -- walk and drive 
output_type = "tts"
speaker = "Monica"
language = "Spanish (Spain)"
marc_code = "spa"
language_id = "4"
id = "4002"
config_file = "spanish_tts/config_tts.lua"
audio_files_path = "spanish_tts/spanish_tts"
rulesets_file = "spanish_tts/spanish_tts/rulesets_SPE.txt"
userdictionary_file = "spanish_tts/spanish_tts/udct_spe.dat"
apdb = "apdb/monica/nm"
audio_files_version = "0.2.0.2012011701"
client_range = "[client >= 1.3.18.0 ; client < 1.4.6.0 ]"

maneuver_check = {
    ["END"] = "usted llegará a su destino",                                   -- You will reach your destination
    ["STOPOVER"] = "usted llegará a su parada intermedia",        -- You will reach a stopover
    ["JUNCTION"] = nil,                                                               -- No voice file needed -> check maneuver_turn
    ["PASS_JUNCTION"] = nil,                                                    -- the junction
    ["ROUNDABOUT"] = "en la rotonda",                                      -- At the roundabout
    ["EXIT_ROUNDABOUT"] = "tome la salida",                             -- take the exit
    ["UTURN"] = "cambie de sentido",                                           -- Make a uturn
    ["ENTER_HIGHWAY"] = "tome la autopista",
    ["LEAVE_HIGHWAY"] = "tome la salida",                                -- take the exit
    ["CONTINUE_HIGHWAY"] = "tome la salida",                             -- due to specifications ("take the exit")
    ["ENTER_URBAN_HIGHWAY"] = "tome la autopista",
    ["LEAVE_URBAN_HIGHWAY"] = "tome la salida",                      -- take the exit
    ["CONTINUE_URBAN_HIGHWAY"] = "continue por la autopista",
    ["DRIVE_TO_NEAREST_ROAD"] = "Circule hasta la próxima carretera",        -- drive to nearest road 
    ["FERRY"] = "tome el ferry"
}

maneuver_turns_car = {
    ["NO_TURN"] = "conduzca todo recto",
    ["KEEP_MIDDLE"] = "tome el carril central",
    ["KEEP_RIGHT"] = "manténgase a la derecha",
    ["LIGHT_RIGHT"] = "gire ligeramente a la derecha",
    ["QUITE_RIGHT"] = "gire a la derecha",
    ["HEAVY_RIGHT"] = "gire pronunciadamente a la derecha",
    ["RETURN"] = "cambie de sentido",
    ["HEAVY_LEFT"] = "gire pronunciadamente a la izquierda",
    ["QUITE_LEFT"] = "gire a la izquierda",
    ["LIGHT_LEFT"] = "gire ligeramente a la izquierda",
    ["KEEP_LEFT"] = "manténgase a la izquierda",
    ["nil"] = nil,
    ["UNDEFINED"] = nil
}

maneuver_turns_pedestrian = {
    ["NO_TURN"] = "siga recto",
    ["KEEP_MIDDLE"] = "tome la calle central",
    ["KEEP_RIGHT"] = "tome la calle de la derecha",
    ["LIGHT_RIGHT"] = "gire ligeramente a la derecha",
    ["QUITE_RIGHT"] = "gire a la derecha",
    ["HEAVY_RIGHT"] = "gire pronunciadamente a la derecha",
    ["RETURN"] = "cambie de sentido",
    ["HEAVY_LEFT"] = "gire pronunciadamente a la iquierda",
    ["QUITE_LEFT"] = "gire a la izquierda",
    ["LIGHT_LEFT"] = "gire ligeramente a la izquierda",
    ["KEEP_LEFT"] = "tome la calle de la izquierda",
    ["nil"] = nil,
    ["UNDEFINED"] = nil
}

pedestrian_vc = {
    ["BUILDING"] = "atraviese el edificio",
    ["SQUARE"] = "cruce la plaza",
    ["PARK"] = "cruce el parque",
    ["STAIRS"] = "tome las escaleras",
    ["ELEVATOR"] = "tome el ascensor",
    ["ESCALATOR"] = "tome las escaleras"
}

final_command = {
    ["END"] = "Usted ha llegado a su destino",                                         -- You have reached your destination
    ["STOPOVER"] = "Usted ha llegado a su parada intermedia"                -- You have reached a stopover
}

exit_number_check = {
    [1] = {"tome la primera salida", "gire en la primera calle"},                               -- take the first exit
    [2] = {"tome la segunda salida", "gire en la segunda calle"},                            -- take the second exit
    [3] = {"tome la tercera salida", "gire en la tercera calle"},                                -- take the third exit
    [4] = {"tome la cuarta salida", "gire en la cuarta calle"},                                  -- take the fourth exit
    [5] = {"tome la quinta salida", "gire en la quinta calle"},                                  -- take the fifth exit
    [6] = {"tome la sexta salida", "gire en la sexta calle"},                                    -- take the sixth exit
    [7] = {"tome la séptima salida", "gire en la séptima calle"},                             -- take the seventh exit
    [8] = {"tome la octava salida", "gire en la octava calle"},                                  -- take the eighth exit
    [9] = {"tome la novena salida", "gire en la novena calle"},                                -- take the ninth exit
    [10] = {"tome la décima salida", "gire en la décima calle"},                              -- take the tenth exit
    [11] = {"tome la décimo primera salida", "gire en la décimo primera calle"},       -- take the eleventh exit
    [12] = {"tome la décimo segunda salida", "gire en la décimo segunda calle"}     -- take the twelfth exit
}

distances = {
    [50] = "50",
    [100] = "100",
    [150] = "150",
    [200] = "200",
    [250] = "250",
    [300] = "300",
    [400] = "400",
    [500] = "500",
    [600] = "600",
    [700] = "700",
    [800] = "800",
    [900] = "900",
    [1] = "1",
    [2] = "2",
    [3] = "3",
    [4] = "4",
    [5] = "5",
    [6] = "6",
    [7] = "7",
    [8] = "8",
    [9] = "9",
    [10] = "10"
}

unit = {                        
    ["MILE"] = "milla",
    ["YARDS"] = "yardas",
    ["KILOMETER"] = "kilómetro",
    ["METERS"] = "metros",
    ["METER"] = "metro",
    ["KILOMETERS"] = "kilómetros",
    ["MILES"] = "millas",
    ["nil"] = nil,
    ["UNDEFINED"] = nil
}

orientation = {
    ["NORTH"] = "al norte",
    ["NORTH_EAST"] = "al nordeste",
    ["EAST"] = "al este",
    ["SOUTH_EAST"] = "al sudeste",
    ["SOUTH"] = "al sur",
    ["SOUTH_WEST"] = "al sudoeste",
    ["WEST"] = "al oeste",
    ["NORTH_WEST"] = "al noroeste"
}

misc = { 
    ["gps_signal_lost_wav"] = "Se ha perdido la señal GPS",
    ["gps_signal_restored_wav"] = "La señal GPS ha sido restablecida",
 --   ["no_gps_signal_wav"] = "Sin señal GPS",
    ["route_recalculation_wav"] = "Recálculo de ruta",
    ["now_wav"] = "Ahora",
    ["end_of_street_wav"] = "Al final de la calle",
    ["follow_motorway_wav"] = "Siga la autopista",
    ["follow_road_wav"] = "Siga la carretera",
    ["for_wav"] = "durante",
    ["after_wav"] = "Después de",
    ["un_wav"] = "un",
    ["una_wav"] = "una",
    ["junction_wav"] = "la intersección",
    ["half_a_mile_wav"] = "media milla",
    ["quarter_a_mile_wav"] = "un cuarto de milla",
    ["immediately_wav"] = "immediatamente",
    ["safety_camara_ahead_wav"] = "Cámara de control de velocidad más adelante",
    ["over_speed_limit_wav"] = "Observe el límite de velocidad",
    ["traffic_automatic_detour_wav"] = "Tráfico en la ruta, desviación.",
    ["traffic_manual_detour_wav"] = "Tráfico en la ruta, ¿desea una ruta alternativa?",
    ["no_detour_possible"] = "No se encontró ninguna ruta alternativa para evitar la congestión de tráfico.",
    ["and_wav"] = "y",
    ["and_then_wav"] = "y luego",
    ["and_then_pedestrian_wav"] = "y",
    ["and_continue_on_wav"] = "y continue por",
    ["towards_wav"] = "dirección",
    ["towards_2_wav"] = "hacia",
    ["turn_wav"] = "gire",
    ["onto_wav"] = "hacia",
    ["exit_wav"] = "tome la salida",
    ["second_right_wav"] = "tome la segunda a la derecha",
    ["second_left_wav"] = "tome la segunda a la izquierda",
    ["dot"] = ".",
    ["walk_left_roundabout_wav"] = "camine por la izquierda en la rotonda",
    ["walk_right_roundabout_wav"] = "camine por la derecha en la rotonda",
    ["walk_roundabout_wav"] = "camine alrededor de la rotonda",
    ["head_wav"] = "Diríjase",
    ["pause"] = "\\pause=50\\",
    ["on_wav"] = "en",
    ["onto_2_wav"] = "por",
    ["the_footpath_wav"] = "por el sendero"
}

wav_files = { 
    ["beep_sound"] = "beep16K.wav"       
}

right = { ["QUITE_RIGHT"] = 0, ["HEAVY_RIGHT"] = 0, ["LIGHT_RIGHT"] = 0, ["KEEP_RIGHT"] = 0 }
left = { ["QUITE_LEFT"] = 0, ["HEAVY_LEFT"] = 0, ["LIGHT_LEFT"] = 0, ["KEEP_LEFT"] = 0 }
keep = { ["KEEP_LEFT"] = 0, ["KEEP_RIGHT"] = 0, ["KEEP_MIDDLE"] = 0 }
highway = { ["ENTER_HIGHWAY"] = 0, ["ENTER_URBAN_HIGHWAY"] = 0, ["LEAVE_HIGHWAY"] = 0, ["LEAVE_URBAN_HIGHWAY"] = 0 }


