-- ----------------------------------------------------------------------------
-- Copyright (C) 2009 Nokia Gate5 GmbH Berlin
--
-- These coded instructions, statements, and computer programs contain
-- unpublished proprietary information of Nokia Gate5 GmbH Berlin, and
-- are copy protected by law. They may not be disclosed to third parties
-- or copied or duplicated in any form, in whole or in part, without the
-- specific, prior written permission of Nokia Gate5 GmbH Berlin.
-- ----------------------------------------------------------------------------
--      Authors: Raul Ferrandez Salvador
-- ----------------------------------------------------------------------------
--             Voice Skin: Spanish TTS

require("common_tts")

function get_voicefiles( )
end

function get_text_output( )
    get_common_code( )
end

function process_pedestrian_triggers( )

    if maneuver_1.id == "HEAD_TO" then
        process_head_to_command( )
    elseif trigger == "PEDESTRIAN_ANNOUNCEMENT" then
        process_pedestrian_announcement( )
    elseif trigger == "PEDESTRIAN_COMMAND" then
        process_pedestrian_final_command( )
    end
    
end

function process_head_to_command( )

    if maneuver_1.heading_orientation ~= nil and maneuver_1.heading_orientation ~= "" then
        add_address_result( { misc[ "head_wav" ], orientation[ maneuver_1.heading_orientation ] } )
        -- Note: "gps_location" was introduced in Sputnik 1.3 -> s60 client SR5
        -- older clients will ignore "gps_location"
        if gps_location ~= nil then 
            if gps_location.street_label ~= nil and gps_location.street_label ~= "" then
                add_address_result( { misc[ "onto_2_wav" ], gps_location.street_label } )
            end
        elseif maneuver_1.street ~= nil and maneuver_1.street ~= "" and pedestrian_vc [ maneuver_1.street ] == nil then
            add_address_result( { misc[ "onto_2_wav" ], maneuver_1.street } )
        elseif maneuver_1.route ~= nil and maneuver_1.route ~= "" and pedestrian_vc [ maneuver_1.street ] == nil then
            add_address_result( { misc[ "onto_2_wav" ], maneuver_1.route } )
        end
        if maneuver_1.next_street ~= nil and maneuver_1.next_street ~= "" and maneuver_1.next_street ~= maneuver_1.street and pedestrian_vc [ maneuver_1.next_street ] == nil then
            add_address_result( { misc[ "towards_2_wav" ], maneuver_1.next_street } )
        elseif maneuver_1.next_route ~= nil and maneuver_1.next_route ~= "" and maneuver_1.next_route ~= maneuver_1.route and pedestrian_vc [ maneuver_1.next_street ] == nil then
            add_address_result( { misc[ "towards_2_wav" ], maneuver_1.next_route } )
        end
    end
    
end

function process_pedestrian_announcement( )
    include_distance( maneuver_1, "pedestrian" )
    add_pedestrian_maneuver_to_table( )
end

function process_pedestrian_final_command( )

    if maneuver_1.id ~= "END" 
    and maneuver_1.id ~= "ROUNDABOUT" 
    and maneuver_1.id ~= "STOPOVER" then
        add_result( misc[ "now_wav" ] ) 
    end
    
    if maneuver_1.id == "END" 
    or maneuver_1.id == "STOPOVER" then
        add_result( final_command[ maneuver_1.id ] ) 
    else
        add_pedestrian_maneuver_to_table( )
    end
    
end

function add_pedestrian_action_vc( )
    
    if pedestrian_vc[ maneuver_1.next_street ] == nil then
        if keep[ maneuver_1.turn ] == nil then   -- add "onto" only if maneuver doesn't belong to "keep" 
            if maneuver_1.next_street ~= "" and maneuver_1.next_street ~= nil then
                if maneuver_1.next_street == maneuver_1.street then
                    add_address_result( { misc[ "and_continue_on_wav" ], maneuver_1.next_street } )
                else
                    add_address_result( { misc[ "onto_wav" ], maneuver_1.next_street } )
                end
            elseif maneuver_1.next_route ~= "" and maneuver_1.next_route ~= nil then
                if maneuver_1.next_route == maneuver_1.route then
                    add_address_result( { misc[ "and_continue_on_wav" ], maneuver_1.next_route } )
                else
                    add_address_result( { misc[ "onto_wav" ], maneuver_1.next_route } )
                end
            elseif maneuver_1.next_street_is_walkway == 1 and maneuver_1.street_is_walkway == 0 then
                add_address_result(  misc[ "the_footpath_wav" ]  )
            end
        elseif double_command == false and maneuver_1.next_street ~= nil and maneuver_1.next_street ~= "" then
            add_address_result( maneuver_1.next_street )
        end
    elseif pedestrian_vc[ maneuver_1.next_street ] ~= pedestrian_vc[ maneuver_1.street ] then
        if junction_turn ~= nil then
            add_result( misc[ "and_wav" ] )
        end
        add_result( pedestrian_vc[ maneuver_1.next_street ] )
    end
        
end

function add_pedestrian_maneuver_to_table( )
    
    get_index_maneuver( 1 )
    junction_turn, maneuver_command = get_maneuver( "pedestrian" )

    if maneuver_1.id == "END" 
     or maneuver_1.id == "STOPOVER" 
     or maneuver_1.id == "UTURN" 
     or maneuver_1.id == "FERRY" then
        add_result( maneuver_command )
    elseif maneuver_1.id == "EXIT_ROUNDABOUT" then
        exiting_roundabout_pedestrian( )
    elseif maneuver_1.id == "ROUNDABOUT" then
        roundabout_pedestrian( )
    else
        add_result( junction_turn )
        add_pedestrian_action_vc()
    end

    if double_command == true and maneuver_1.id ~= "ROUNDABOUT" then
        get_index_maneuver( 2 )
        junction_turn, maneuver_command = get_maneuver( "pedestrian" )
        add_result({ misc[ "pause" ], misc[ "and_then_pedestrian_wav" ]  } )
        include_distance ( maneuver_2, "pedestrian" )
        if maneuver_2.id == "ROUNDABOUT" then
            roundabout_pedestrian( )
        elseif junction_turn ~= nil then 
           add_result( junction_turn )
        else
           add_result( maneuver_command )
        end        
    end
    
end

function get_index_maneuver( index )

    if index == 1 then
        maneuver = maneuver_1
        use_dgttsp = use_dgttsp_1
        junction_turn = junction_turn_1
        maneuver_command = maneuver_command_1
    elseif index == 2 then
        maneuver = maneuver_2
        use_dgttsp = use_dgttsp_2
        junction_turn = junction_turn_2
        maneuver_command = maneuver_command_2
    end

end

function roundabout_pedestrian( )

    if maneuver.turn == "QUITE_RIGHT" then
        add_result( misc[ "walk_right_roundabout_wav" ] )
    elseif maneuver.turn == "QUITE_LEFT" then
        add_result( misc[ "walk_left_roundabout_wav" ] )
    else
        add_result( misc[ "walk_roundabout_wav" ] )
    end
    if maneuver == maneuver_1 then
    	  if maneuver_1.next_street ~= nil and maneuver_1.next_street ~= "" then
    	  	  add_address_result( { misc[ "and_continue_on_wav" ], maneuver_1.next_street } )
    	  elseif maneuver_1.next_route ~= nil and maneuver_1.next_route ~= "" then
    	  	  add_address_result( { misc[ "and_continue_on_wav" ], maneuver_1.next_route } )
    	  else
		        exit_roundabout_pedestrian = exit_number_check[ maneuver.extra_integer ] [2]
		        add_result( { misc[ "and_wav" ], exit_roundabout_pedestrian } )
	  end  
    end

end

function exiting_roundabout_pedestrian( )

    if maneuver_1.turn == "QUITE_RIGHT" then
        add_result( maneuver_turns_pedestrian[ "QUITE_RIGHT" ] )
    elseif maneuver_1.turn == "QUITE_LEFT" then
        add_result( maneuver_turns_pedestrian[ "QUITE_LEFT" ] )
    else
        add_result( misc[ "turn_wav" ] )
    end
    if maneuver_1.next_street_is_walkway == 1 
    and ( maneuver_1.next_street == "" or maneuver_1.next_street == nil ) then
        add_result(  misc[ "the_footpath_wav" ]  )
    elseif maneuver_1.next_street ~= nil and maneuver_1.next_street ~= "" then
        add_address_result( { misc[ "onto_wav" ], maneuver_1.next_street } )
    end

end

function roundabout_car( )

    exit_roundabout_car = exit_number_check[ maneuver.extra_integer ] [1]
    add_result( exit_roundabout_car )

end 

function process_car_triggers( )

    if maneuver_1.id == "HEAD_TO" then
        process_head_to_command( )
    elseif trigger == "COMMAND" then   
        process_car_final_command( )
    elseif trigger == "REMINDER1" then
        process_car_reminders( )
    elseif trigger == "REMINDER2" then
        process_car_reminders( )
    elseif trigger == "ANNOUNCEMENT" then   
        process_car_announcement( )
    end
    
end

function process_car_final_command( )

    if maneuver_1.id ~= "END" 
    and maneuver_1.id ~= "ROUNDABOUT" 
    and maneuver_1.id ~= "STOPOVER" 
    and maneuver_1.id ~= "DRIVE_TO_NEAREST_ROAD"
    and maneuver_1.id ~= "PASS_JUNCTION" then
        -- "now"
        add_result( misc[ "now_wav" ] )
    end
    
    if maneuver_1.id == "END" 
    or maneuver_1.id == "STOPOVER" then
        add_result( final_command[ maneuver_1.id ] )
    elseif maneuver_1.id == "PASS_JUNCTION" then
        add_result( { misc[ "after_wav" ], misc[ "junction_wav" ] } )
        add_car_maneuver_to_table( )
    else
        add_car_maneuver_to_table( )
    end

end

function process_car_reminders( )

    -- If maneuver is "at the end of the street"
    if maneuver_1.extra_string == "EOS" and trigger == "REMINDER1" then
        add_result( misc[ "end_of_street_wav" ] )
    else
        include_distance( maneuver_1, "car" )
    end
    add_car_maneuver_to_table( )
    
end


function process_car_announcement( )

    if maneuver_1.dist_to >= 10000 then
        -- i.e.: "follow A2 Autopista del Mediterraneo"
        -- set tts engine to address mode
        if road_class == "HIGHWAY" then
            if gps_location ~= nil then 
                 if ( gps_location.fow == "SLIPROAD"  )then
                    add_address_result( { misc[ "follow_motorway_wav" ], maneuver_1.route  } )
                elseif ( gps_location.fow == "MOTORWAY"  )then
                    add_address_result( { misc[ "follow_motorway_wav" ], gps_location.route  } )
                else
                    add_address_result( { misc[ "follow_motorway_wav" ], gps_location.street_label } )
                end
            else
                add_address_result( { misc[ "follow_motorway_wav" ], maneuver_1.route } )
            end
        else
            add_result( misc[ "follow_road_wav" ]  )
        end
    elseif road_class == "STREET" and maneuver_1.dist_to >= 3000 then
        -- i.e.: "follow Oxford Street for X km/miles"
        add_result( { misc[ "follow_road_wav" ], misc[ "for_wav" ], maneuver_1.dist_to_unit, unit[ maneuver_1.dist_unit ] } )
    else
        include_distance( maneuver_1, "car" )
        add_car_maneuver_to_table( )
    end
    
end

function get_maneuver( mode )
    
    if mode == "car" then
        maneuver_turns = maneuver_turns_car
    else 
        maneuver_turns = maneuver_turns_pedestrian
    end

    if maneuver ~= nil then
        junction_turn = maneuver_turns[ maneuver.turn ]
        maneuver_command = maneuver_check[ maneuver.id ]
    end

    return junction_turn, maneuver_command
end

function include_distance( maneuver, mode )
    
    if maneuver ~= nil then
        
        add_result( misc[ "after_wav" ] )
        if maneuver.dist_to_unit >= 800 and maneuver.dist_to_unit <= 900
        and maneuver.dist_unit == "YARDS" then
            add_result( misc[ "half_a_mile_wav" ] )
        elseif maneuver.dist_to_unit >= 400 and maneuver.dist_to_unit <= 500
        and maneuver.dist_unit == "YARDS" then
            add_result( misc[ "quarter_a_mile_wav" ] )
        elseif maneuver.dist_to_unit == 1 and maneuver.dist_unit == "KILOMETER" then
            add_result( { misc[ "un_wav" ], unit[ maneuver.dist_unit ] } )
        elseif maneuver.dist_to_unit == 1 and maneuver.dist_unit == "MILE" then
            add_result( { misc[ "una_wav" ], unit[ maneuver.dist_unit ] } ) 
        elseif mode == "car" then
            -- insert distance to maneuver + unit to maneuver
            add_result( {  distances[maneuver.dist_to_unit], unit[ maneuver.dist_unit ] } )
        else -- pedestrian
            add_result( {  maneuver.dist_to_unit, unit[ maneuver.dist_unit ] } )
        end
        
    end
    
end

function insert_signpost_enter_hwy( )

    if use_dgttsp == true then
        if maneuver.next_route ~= "" then
            add_address_result( maneuver.next_route ) 
        elseif maneuver.next_street ~= "" then
            add_address_result( maneuver.next_street ) 
        end
        if maneuver.signpost_direction ~= "" and use_dgttsp == true then
            add_address_result( { misc[ "towards_wav" ], maneuver.signpost_direction } )
        end
    end

end

function insert_signpost_leave_or_continue_hwy( )   -- Also valid for junctions on hwy

    if ( maneuver_1.signpost_exit_number ~= "" or maneuver_1.signpost_exit_name ~= "" ) and use_dgttsp_1 == true  then
        add_address_result( { misc[ "exit_wav" ], maneuver_1.signpost_exit_number } ) 
        if ( maneuver_1.signpost_exit_name ~= "" and maneuver_1.signpost_exit_name ~= nil ) then 
            add_address_result ( { misc[ "pause" ], maneuver_1.signpost_exit_name  } )
        end
        
        if double_command == false then
        
            if ( maneuver_1.next_route ~= "" and maneuver_1.next_route ~= nil ) or (maneuver_1.signpost_direction ~= nil and maneuver_1.signpost_direction ~= "" ) then
                if ( maneuver_1.route ~= maneuver_1.next_route ) and ( maneuver_1.next_route ~= nil and maneuver_1.next_route ~= "" ) then
                    add_address_result( { misc[ "towards_wav" ], maneuver_1.next_route, maneuver_1.signpost_direction } )
                elseif ( maneuver_1.route == maneuver_1.next_route ) and ( maneuver_1.next_route ~= nil and maneuver_1.next_route ~= ""  ) then
                    add_address_result( { misc[ "and_continue_on_wav" ], maneuver_1.next_route } )
                    if maneuver_1.signpost_direction ~= "" and maneuver_1.signpost_direction ~= nil and maneuver_1.signpost_direction ~= maneuver_1.signpost_exit_name then
                        add_address_result( { misc[ "towards_wav" ], maneuver_1.signpost_direction } ) 
                    end
                elseif maneuver_1.signpost_direction ~= "" and maneuver_1.signpost_direction ~= nil and maneuver_1.signpost_direction ~= maneuver_1.signpost_exit_name then
                    add_address_result( { misc[ "towards_wav" ], maneuver_1.signpost_direction } ) 
                end
            end
        
        -- double command == true    
        else
            second_command_leave_or_continue_hwy( )
            if ( maneuver_2.signpost_direction == "" or maneuver_2.signpost_direction == nil ) and ( maneuver_1.signpost_direction ~= "" and maneuver_1.signpost_direction ~= nil ) 
              and ( maneuver_2.id ~= "END" and maneuver_2.id ~= "STOPOVER" ) then
                add_address_result( { misc[ "towards_wav" ], maneuver_2.next_route, maneuver_1.signpost_direction } ) 
            elseif ( maneuver_2.signpost_direction ~= "" and maneuver_2.signpost_direction ~= nil ) or ( maneuver_2.next_route ~= "" and maneuver_2.next_route ~= nil ) then
                add_address_result( { misc[ "towards_wav" ], maneuver_2.next_route, maneuver_2.signpost_direction } ) 
            end
        end
        
    elseif ( maneuver_1.signpost_direction ~= "" and maneuver_1.signpost_direction ~= nil ) and use_dgttsp_1 == true then
        if double_command == true then
            second_command_leave_or_continue_hwy( )
        end
        add_address_result( { misc[ "towards_wav" ], maneuver_2.next_route, maneuver_1.signpost_direction } ) 
    else
        if double_command == false and junction_turn ~= misc[ "second_right_wav" ] and junction_turn ~= misc[ "second_left_wav" ]  and maneuver_1.id == "LEAVE_HIGHWAY" then
            if junction_turn ~= nil then
                add_result( misc[ "and_wav" ] ) 
            end
            add_result( maneuver_check[ "LEAVE_HIGHWAY" ] )
        elseif double_command == true then
            if maneuver.id == "LEAVE_HIGHWAY" then
                add_result( maneuver_check[ "LEAVE_HIGHWAY" ] ) 
            end
            second_command_leave_or_continue_hwy( )
        end
    end

end

function second_command_leave_or_continue_hwy( )

    get_index_maneuver( 2 )
    junction_turn, maneuver_command = get_maneuver( "car" )
    add_result( misc[ "and_then_wav" ] ) 
    if maneuver.id == "ROUNDABOUT" then
        add_result( maneuver_command )
        roundabout_car( )         
    else
        if junction_turn ~= nil then
            maneuver_command = nil
        end
        add_result( { junction_turn, maneuver_command } ) 
    end 

end

function insert_signpost_roundabout( )

    if use_dgttsp_1 == true then
        if maneuver_1.signpost_direction ~= "" and maneuver_1.signpost_direction ~= nil then
            add_address_result( { misc[ "towards_wav" ], maneuver_1.signpost_direction } )
        elseif maneuver_1.next_street ~= "" and maneuver_1.next_street ~= nil then  
            add_address_result( { misc[ "onto_wav" ], maneuver_1.next_street } )
        elseif maneuver_1.next_route ~= "" and maneuver_1.next_route ~= nil then
            add_address_result( { misc[ "onto_wav" ], maneuver_1.next_route } )
        end
    end

end

function last_command_before_exit( )

    if right[ maneuver.turn ] ~= nil and maneuver.exits_right == 1 then
        -- take the second right
        junction_turn = misc[ "second_right_wav" ]
        maneuver_command = nil
    elseif left[ maneuver.turn ] ~= nil and maneuver.exits_left == 1 then
        -- take the second left
        junction_turn = misc[ "second_left_wav" ]
        maneuver_command = nil
    end
         
end

function add_street_name_or_route( )

    if use_dgttsp == true or maneuver.id == "EXIT_ROUNDABOUT" then
        if maneuver.id == "END" or maneuver.id == "STOPOVER" then
            if ( maneuver.street ~= "" and maneuver.street ~= nil ) then
                add_address_result( { misc[ "on_wav" ], maneuver.street } ) 
            elseif ( maneuver.route ~= "" and maneuver.route ~= nil ) then
                add_address_result( { misc[ "on_wav" ], maneuver.route } ) 
            end
        elseif road_class == "HIGHWAY" and ( maneuver.signpost_direction ~= "" and maneuver.signpost_direction ~= nil ) then
            add_address_result( { misc[ "towards_wav" ], maneuver.signpost_direction } )
        elseif road_class == "STREET" then
            if ( maneuver.signpost_direction ~= "" and maneuver.signpost_direction ~= nil ) then
                add_address_result( { misc[ "towards_wav" ], maneuver.signpost_direction } )
            elseif ( maneuver.next_street ~= "" and maneuver.next_street ~= nil ) then
                add_address_result( { misc[ "onto_wav" ], maneuver.next_street } )
            elseif ( maneuver.next_route ~= "" and maneuver.next_route ~= nil ) then
                add_address_result( { misc[ "onto_wav" ], maneuver.next_route } )
            end
        end
    end
    
end

function add_car_maneuver_to_table( )
    
    get_index_maneuver( 1 )
    junction_turn, maneuver_command = get_maneuver( "car" )
        
    if maneuver_1.id == "ENTER_HIGHWAY" or maneuver_1.id == "ENTER_URBAN_HIGHWAY" then
        add_result( junction_turn )
        if double_command == false and junction_turn ~= nil then
            add_result( misc[ "and_then_wav" ] )
        end 
        
        add_result( maneuver_command )
        insert_signpost_enter_hwy( )
    
    elseif maneuver_1.id == "END" 
     or maneuver_1.id == "STOPOVER" then
        add_result( maneuver_command )        
        add_street_name_or_route( )
        
    elseif maneuver_1.id == "DRIVE_TO_NEAREST_ROAD"
     or maneuver_1.id == "FERRY" 
     or maneuver_1.id == "EXIT_ROUNDABOUT" then
        
        add_result( maneuver_command )
        if double_command == false then
            add_street_name_or_route( )
        end
        
    elseif maneuver_1.id == "ROUNDABOUT" then
        
        add_result( maneuver_command )
        roundabout_car( )         
        insert_signpost_roundabout( )
        
    elseif maneuver_1.id == "UTURN" then
        add_result( maneuver_command )
        
    elseif road_class == "HIGHWAY" then
        add_result( junction_turn )
        insert_signpost_leave_or_continue_hwy( ) 
        
    else
        add_result( junction_turn )    
        add_street_name_or_route( )
    end

    if double_command == true 
        and road_class ~= "HIGHWAY" then
        
        get_index_maneuver( 2 )
        junction_turn, maneuver_command = get_maneuver( "car" )
        add_result( misc[ "and_then_wav" ] )  
        
        if maneuver_2.dist_to <= 30 
        and maneuver_2.id ~= "END" 
        and maneuver_2.id ~= "ROUNDABOUT" 
        and maneuver_2.id ~= "STOPOVER" then  
            add_result( misc[ "immediately_wav" ] )  
        end

        if maneuver_2.id == "JUNCTION" then    
            last_command_before_exit( ) 
            add_result( junction_turn )
        else
            -- if second maneuver = enter/change hwy, then read only the junction attribute 
            if highway[ maneuver_2.id ] ~= nil then 
                if maneuver_2.turn ~= nil and maneuver_2.turn ~= "UNDEFINED" then
                    maneuver_command = nil
                end
            elseif maneuver_2.id == "ROUNDABOUT" or maneuver_2.id == "EXIT_ROUNDABOUT" then
                junction_turn = nil
            end
            add_result( { junction_turn, maneuver_command } )  
            if maneuver_2.id == "ROUNDABOUT" then
                roundabout_car( )        
            end
        end
        if maneuver_2.id == "ENTER_HIGHWAY" or maneuver_2.id == "ENTER_URBAN_HIGHWAY" then
            insert_signpost_enter_hwy( )
        else
            add_street_name_or_route( )
        end
    end
end
