description = "" 
output_type = "audio"
speaker = ""
gender = "m"
travel_mode = "1"
language = "Serbian"
marc_code = "srp"
id = "79101"
language_id = "79"
config_file = "serbian_m/config.lua"
audio_files_path = "serbian_m/serbian_male"
audio_files_version = "0.2.0.2011082301"
client_range = "[client >= 1.3.15.0 ; client < 1.4.6.0 ]"

down = 1
up = 2

maneuver_turns = {
    ["NO_TURN"] = {"g5man_001e", "g5man_001"},
    ["KEEP_MIDDLE"] = {"g5man_012e", "g5man_012"},
    ["KEEP_RIGHT"] = {"g5turns_right_002e", "g5turns_right_002"},
    ["LIGHT_RIGHT"] = {"g5turns_right_003e", "g5turns_right_003"},
    ["QUITE_RIGHT"] = {"g5turns_right_001e", "g5turns_right_001"},
    ["HEAVY_RIGHT"] = {"g5turns_right_004e", "g5turns_right_004"},
    ["RETURN"] = {"g5man_005e", "g5man_005"},
    ["HEAVY_LEFT"] = {"g5turns_left_004e", "g5turns_left_004"},
    ["QUITE_LEFT"] = {"g5turns_left_001e", "g5turns_left_001"},
    ["LIGHT_LEFT"] = {"g5turns_left_003e", "g5turns_left_003"},
    ["KEEP_LEFT"] = {"g5turns_left_002e", "g5turns_left_002"},
    ["nil"] = {nil, nil},
    ["UNDEFINED"] = {nil, nil}
}


maneuver_check = {
    ["END"] = {"g5ann_001e_alt2", "g5ann_001e_alt2"},              -- You will reached your destination
    ["STOPOVER"] = {"g5ann_002e_alt2", "g5ann_002e_alt2"},         -- You will reached a stopover
    ["JUNCTION"] = {nil, nil},                                     -- No voice file needed -> check maneuver_turn
    ["PASS_JUNCTION"] = {nil, nil},                                -- the junction
    ["ROUNDABOUT"] = {"g5mod_005", "g5mod_005"},                   -- At the roundabout
    ["EXIT_ROUNDABOUT"] = {"g5ext_000e", "g5ext_000"},             -- take the exit
    ["UTURN"] = {"g5man_005e", "g5man_005"},                       -- Make a uturn
    ["ENTER_HIGHWAY"] = {"g5man_008e_alt1", "g5man_008_alt1"},
    ["LEAVE_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},               -- take the exit
    ["CHANGE_HIGHWAY"] = {"g5man_009e_alt1", "g5man_009_alt1"},
    ["CONTINUE_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},
    ["ENTER_URBAN_HIGHWAY"] = {"g5man_008e_alt1", "g5man_008_alt1"},
    ["LEAVE_URBAN_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},              -- take the exit
    ["CHANGE_URBAN_HIGHWAY"] = {"g5man_009e_alt1", "g5man_009_alt1"},
    ["CONTINUE_URBAN_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},
    ["DRIVE_TO_NEAREST_ROAD"] = {"g5serv_001", "g5serv_001"},           -- drive to nearest road 
    ["FERRY"] = {"g5man_016e", "g5man_016"}
}


exit_number_check = {
    [1] = {"g5ext_001e","g5ext_001"},                   -- take the first exit
    [2] = {"g5ext_002e","g5ext_002"},                   -- take the second exit
    [3] = {"g5ext_003e","g5ext_003"},                   -- take the third exit
    [4] = {"g5ext_004e","g5ext_004"},                   -- take the fourth exit
    [5] = {"g5ext_005e","g5ext_005"},                   -- take the fifth exit
    [6] = {"g5ext_006e","g5ext_006"},                   -- take the sixth exit
    [7] = {"g5ext_007e","g5ext_007"},                   -- take the seventh exit
    [8] = {"g5ext_008e","g5ext_008"},                   -- take the eighth exit
    [9] = {"g5ext_009e","g5ext_009"},                   -- take the ninth exit
    [10] = {"g5ext_010e","g5ext_010"},                  -- take the tenth exit
    [11] = {"g5ext_011e","g5ext_011"},                  -- take the eleventh exit
    [12] = {"g5ext_012e","g5ext_012"}                   -- take the twelfth exit
}


-- distances( maneuver.dist_to_unit) [1] = distances in metric
-- distances( maneuver.dist_to_unit) [2] = distances in imperial
distances = {
    [50] = {"g5num_050_after_m", "g5num_050_after_m"},
    [100] = {"g5num_100_after_m", "g5num_100_after_m"},
    [150] = {"g5num_150_after_m", "g5num_150_after_m"},
    [200] = {"g5num_200_after_m", "g5num_200_after_m"},
    [250] = {"g5num_250_after_m", "g5num_250_after_m"},
    [300] = {"g5num_300_after_m", "g5num_300_after_m"},
    [400] = {"g5num_400_after_m", "g5num_400_after_m"},
    [500] = {"g5num_500_after_m", "g5num_500_after_m"},
    [600] = {"g5num_600_after_m", "g5num_600_after_m"},
    [700] = {"g5num_700_after_m", "g5num_700_after_m"},
    [800] = {"g5num_800_after_m", "g5num_800_after_m"},
    [900] = {"g5num_900_after_m", "g5num_900_after_m"},
    [1] = {"g5num_001_after_k", "g5num_001_after_m"},
    [2] = {"g5num_002_after_k", "g5num_002_after_m"},
    [3] = {"g5num_003_after_m", "g5num_003_after_m"},
    [4] = {"g5num_004_after_m", "g5num_004_after_m"},
    [5] = {"g5num_005_after_m", "g5num_005_after_m"},
    [6] = {"g5num_006_after_m", "g5num_006_after_m"},
    [7] = {"g5num_007_after_m", "g5num_007_after_m"},
    [8] = {"g5num_008_after_m", "g5num_008_after_m"},
    [9] = {"g5num_009_after_m", "g5num_009_after_m"},
    [10] = {"g5num_010_after_m", "g5num_010_after_m"}
}

unit = {                                    -- Intonation down, intonation up
    ["MILE"] = {"g5unt_m_after_1","g5unt_m_after_1"},
    ["YARDS"] = {"g5unt_yd_after_5","g5unt_yd_after_5"},
    ["KILOMETER"] = {"g5unt_km_after_1","g5unt_km_after_1"},
    ["METERS"] = {"g5unt_me_after_5","g5unt_me_after_5"},
    ["METER"] = {nil, nil},
    ["KILOMETERS"] = {"g5unt_km_after_5","g5unt_km_after_5"},
    ["MILES"] = {"g5unt_m_after_5","g5unt_m_after_5"},
    ["nil"] = {nil, nil},
    ["UNDEFINED"] = {nil, nil}
}

misc = { 
    ["beep_sound"] = "beep",
    ["gps_signal_lost_wav"] = "g5war_027e",
    ["gps_signal_restored_wav"] = "g5war_010e",
    ["no_gps_signal_wav"] = "g5war_028e",
    ["route_recalculation_wav"] = "g5war_012e",
    ["now_wav"] = "g5mod_007",
    ["destination_wav"] = "g5ann_001e",
    ["stopover_wav"] = "g5ann_002e",
    ["end_of_street_wav"] = "g5mod_004",
    ["follow_hwy_wav"] = "g5man_003e_alt1",
    ["follow_road_e_wav"] = "g5man_002e",
    ["follow_road_wav"] = "g5man_002",
    ["the_junction_wav"] = "g5mod_016",
    ["for_wav"] = "g5pre_002_road_km",
    ["roundabout_wav"] = "g5mod_005",
    ["after_wav"] = "g5pre_003",
    ["jedne_wav"] = "g5num_001_after_m",
    ["jednog_wav"] = "g5num_001_after_k",
    ["dva_wav"] = "g5num_002_after_k",
    ["dve_wav"] = "g5num_002_after_m",
    ["kilometra_wav"] = "g5unt_km_after_1",
    ["kilometara_wav"] = "g5unt_km_after_5",
    ["milja_wav"] = "g5unt_m_after_5",
    ["milje_wav"] = "g5unt_m_after_1",
    ["and_wav"] = "g5con_002",
    ["second_right_wav"] = "g5turns_right_006e",
    ["second_left_wav"] = "g5turns_left_006e",
    ["immediately_wav"] = "g5immediately",
    ["safety_camara_ahead_wav"] = "g5war_035e",
    ["over_speed_limit_wav"] = "g5war_016e",
    ["traffic_automatic_detour_wav"] = "g5war_018e",
    ["traffic_manual_detour_wav"] = "g5war_017e",
    ["no_detour_possible"] = "g5war_021e",
    ["and_then_wav"] = "g5con_001"

}

right = { ["QUITE_RIGHT"] = 0, ["HEAVY_RIGHT"] = 0, ["LIGHT_RIGHT"] = 0, ["KEEP_RIGHT"] = 0 }
left = { ["QUITE_LEFT"] = 0, ["HEAVY_LEFT"] = 0, ["LIGHT_LEFT"] = 0, ["KEEP_LEFT"] = 0 }


check_files = { maneuver_turns, maneuver_check, exit_number_check, distances, unit, misc }