description = "" 
output_type = "audio"
speaker = ""
gender = "f"
travel_mode = "1"
language = "Lithuanian"
marc_code = "lit"
language_id = "68"
id = "68000"
config_file = "lithuanian_f/config.lua"
audio_files_path = "lithuanian_f/lithuanian_female"
audio_files_version = "0.2.0.2011082301"
client_range = "[client >= 1.3.15.0 ; client < 1.4.6.0 ]"

down = 1
up = 2

maneuver_turns = {
    ["NO_TURN"] = {"g5man_001e", "g5man_001"},
    ["KEEP_MIDDLE"] = {"g5man_012e", "g5man_012"},
    ["KEEP_RIGHT"] = {"g5turns_right_002e", "g5turns_right_002"},
    ["LIGHT_RIGHT"] = {"g5turns_right_003e", "g5turns_right_003"},
    ["QUITE_RIGHT"] = {"g5turns_right_001e", "g5turns_right_001"},
    ["HEAVY_RIGHT"] = {"g5turns_right_004e", "g5turns_right_004"},
    ["RETURN"] = {"g5man_005e", "g5man_005"},
    ["HEAVY_LEFT"] = {"g5turns_left_004e", "g5turns_left_004"},
    ["QUITE_LEFT"] = {"g5turns_left_001e", "g5turns_left_001"},
    ["LIGHT_LEFT"] = {"g5turns_left_003e", "g5turns_left_003"},
    ["KEEP_LEFT"] = {"g5turns_left_002e", "g5turns_left_002"},
    ["nil"] = {nil, nil},
    ["UNDEFINED"] = {nil, nil}
}


maneuver_check = {
    ["END"] = {"g5ann_001e_alt2", "g5ann_001e_alt2"},              -- You will reached your destination
    ["STOPOVER"] = {"g5ann_002e_alt2", "g5ann_002e_alt2"},         -- You will reached a stopover
    ["JUNCTION"] = {nil, nil},                                     -- No voice file needed -> check maneuver_turn
    ["PASS_JUNCTION"] = {nil, nil},                                -- the junction
    ["ROUNDABOUT"] = {"g5mod_005", "g5mod_005"},                   -- At the roundabout
    ["EXIT_ROUNDABOUT"] = {"g5ext_000e", "g5ext_000"},             -- take the exit
    ["UTURN"] = {"g5man_005e", "g5man_005"},                       -- Make a uturn
    ["ENTER_HIGHWAY"] = {"g5man_008e", "g5man_008"},
    ["LEAVE_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},               -- take the exit
    ["CHANGE_HIGHWAY"] = {"g5man_009e", "g5man_009"},
    ["CONTINUE_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},
    ["ENTER_URBAN_HIGHWAY"] = {"g5man_008e", "g5man_008"},
    ["LEAVE_URBAN_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},         -- take the exit
    ["CHANGE_URBAN_HIGHWAY"] = {"g5man_009e", "g5man_009"},
    ["CONTINUE_URBAN_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},
    ["DRIVE_TO_NEAREST_ROAD"] = {"g5serv_001", "g5serv_001"},      -- drive to nearest road 
    ["FERRY"] = {"g5man_016e", "g5man_016"}
}


exit_number_check = {
    [1] = {"g5ext_001e","g5ext_001"},                   -- take the first exit
    [2] = {"g5ext_002e","g5ext_002"},                   -- take the second exit
    [3] = {"g5ext_003e","g5ext_003"},                   -- take the third exit
    [4] = {"g5ext_004e","g5ext_004"},                   -- take the fourth exit
    [5] = {"g5ext_005e","g5ext_005"},                   -- take the fifth exit
    [6] = {"g5ext_006e","g5ext_006"},                   -- take the sixth exit
    [7] = {"g5ext_007e","g5ext_007"},                   -- take the seventh exit
    [8] = {"g5ext_008e","g5ext_008"},                   -- take the eighth exit
    [9] = {"g5ext_009e","g5ext_009"},                   -- take the ninth exit
    [10] = {"g5ext_010e","g5ext_010"},                  -- take the tenth exit
    [11] = {"g5ext_011e","g5ext_011"},                  -- take the eleventh exit
    [12] = {"g5ext_012e","g5ext_012"}                   -- take the twelfth exit
}


-- 1= masculine (km/meters) 2= femenine (miles/yards)
distances = {
    [50] = {"g5num_050", "g5num_050"},
    [100] = {"g5num_100_after", "g5num_100_after"},
    [150] = {"g5num_150_after", "g5num_150_after"},
    [200] = {"g5num_200_after", "g5num_200_after"},
    [250] = {"g5num_250_after", "g5num_250_after"},
    [300] = {"g5num_300_after", "g5num_300_after"},
    [400] = {"g5num_400_after", "g5num_400_after"},
    [500] = {"g5num_500_after", "g5num_500_after"},
    [600] = {"g5num_600_after", "g5num_600_after"},
    [700] = {"g5num_700_after", "g5num_700_after"},
    [800] = {"g5num_800_after", "g5num_800_after"},
    [900] = {"g5num_900_after", "g5num_900_after"},
    [1] = {"g5num_001_after_m", "g5num_001_after_f"},
    [2] = {"g5num_002_after", "g5num_002_after"},
    [3] = {"g5num_003_after", "g5num_003_after"},
    [4] = {"g5num_004_after", "g5num_004_after"},
    [5] = {"g5num_005_after", "g5num_005_after"},
    [6] = {"g5num_006_after", "g5num_006_after"},
    [7] = {"g5num_007_after", "g5num_007_after"},
    [8] = {"g5num_008_after", "g5num_008_after"},
    [9] = {"g5num_009_after", "g5num_009_after"},
    [10] = {"g5num_010", "g5num_010"}
}

-- 1= masculine (km/meters) 2= femenine (miles/yards)
distances_follow = {
    [50] = {nil, nil},
    [100] = {nil, nil},
    [150] = {nil, nil},
    [200] = {nil, nil},
    [250] = {nil, nil},
    [300] = {nil, nil},
    [400] = {nil, nil},
    [500] = {nil, nil},
    [600] = {nil, nil},
    [700] = {nil, nil},
    [800] = {nil, nil},
    [900] = {nil, nil},
    [1] = {nil, nil},
    [2] = {"g5num_002_follow_m", "g5num_002_follow_f"},
    [3] = {"g5num_003_follow", "g5num_003_follow"},
    [4] = {"g5num_004_follow_m", "g5num_004_follow_f"},
    [5] = {"g5num_005_follow_m", "g5num_005_follow_f"},
    [6] = {"g5num_006_follow_m", "g5num_006_follow_f"},
    [7] = {"g5num_007_follow_m", "g5num_007_follow_f"},
    [8] = {"g5num_008_follow_m", "g5num_008_follow_f"},
    [9] = {"g5num_009_follow_m", "g5num_009_follow_f"},
    [10] = {"g5num_010", "g5num_010"}
}

unit = {                                    -- Intonation down, intonation up
    ["MILE"] = {"g5unt_mil_after_1","g5unt_mil_after_1"},
    ["YARDS"] = {"g5unt_yd_after_X","g5unt_yd_after_X"},
    ["KILOMETER"] = {"g5unt_km_after_1","g5unt_km_after_1"},
    ["METERS"] = {"g5unt_m_after_X","g5unt_m_after_X"},
    ["METER"] = {nil, nil},
    ["KILOMETERS"] = {"g5unt_km_follow_5e","g5unt_km_after_X"},
    ["MILES"] = {"g5unt_mil_follow_5e","g5unt_mil_after_X"},
    ["nil"] = {nil, nil},
    ["UNDEFINED"] = {nil, nil}
}

misc = { 
    ["beep_sound"] = "beep",
    ["gps_signal_lost_wav"] = "g5war_027e",
    ["gps_signal_restored_wav"] = "g5war_010e",
    ["no_gps_signal_wav"] = "g5war_028e",
    ["route_recalculation_wav"] = "g5war_012e",
    ["now_wav"] = "g5mod_007",
    ["destination_wav"] = "g5ann_001e",
    ["stopover_wav"] = "g5ann_002e",
    ["end_of_street_wav"] = "g5mod_004",
    ["follow_hwy_wav"] = "g5man_003e",
    ["follow_road_e_wav"] = "g5man_002e",
    ["follow_road_wav"] = "g5man_002",
    ["the_junction_wav"] = "g5mod_018_alt1",
    ["take_roundabout_wav"] = "g5ext_take",
    ["for_wav"] = nil,                                  -- "for" is not required 
    ["roundabout_wav"] = "g5mod_005",
    ["after_wav"] = "g5pre_003",
    ["kilometers_10_wav"] = "g5unt_km_follow_Xe",       -- only for follow road for 10 km (see config.lua)
    ["miles_10_wav"] = "g5unt_mil_follow_Xe",           -- only for follow road for 10 miles (see config.lua)
    ["half_a_mile_wav"] = "g5num_050_mil",
    ["quarter_a_mile_wav"] = "g5num_025_mil",
    ["and_wav"] = "g5con_002",
    ["second_right_wav"] = "g5turns_right_006e",
    ["second_left_wav"] = "g5turns_left_006e",
    ["immediately_wav"] = "g5mod_007_imm_alt1",
    ["safety_camara_ahead_wav"] = "g5war_037e",
    ["over_speed_limit_wav"] = "g5war_005e",
    ["traffic_automatic_detour_wav"] = "g5war_018e",
    ["traffic_manual_detour_wav"] = "g5war_017e",
    ["and_then_wav"] = "g5con_001"

}

right = { ["QUITE_RIGHT"] = 0, ["HEAVY_RIGHT"] = 0, ["LIGHT_RIGHT"] = 0, ["KEEP_RIGHT"] = 0 }
left = { ["QUITE_LEFT"] = 0, ["HEAVY_LEFT"] = 0, ["LIGHT_LEFT"] = 0, ["KEEP_LEFT"] = 0 }


check_files = { maneuver_turns, maneuver_check, exit_number_check, distances, distances_follow, unit, misc }