description = "" 
output_type = "audio"
speaker = ""
gender = "m"
travel_mode = "1"
language = "Indonesian"
marc_code = "ind"
language_id = "59"
id = "59101"
config_file = "indonesian_m/config.lua"
audio_files_path = "indonesian_m/indonesian_male"
audio_files_version = "0.2.0.2011082301"
client_range = "[client >= 1.3.15.0 ; client < 1.4.6.0 ]"

down = 1
up = 2

maneuver_turns = {
    ["NO_TURN"] = {"g5man_001e", "g5man_001"},
    ["KEEP_MIDDLE"] = {"g5man_009e", "g5man_009"},
    ["KEEP_RIGHT"] = {"g5tur_001e", "g5tur_001"},
    ["LIGHT_RIGHT"] = {"g5tur_002e", "g5tur_002"},
    ["QUITE_RIGHT"] = {"g5tur_005e", "g5tur_005"},
    ["HEAVY_RIGHT"] = {"g5tur_004e", "g5tur_004"},
    ["RETURN"] = {"g5man_004e", "g5man_004"},
    ["HEAVY_LEFT"] = {"g5tul_004e", "g5tul_004"},
    ["QUITE_LEFT"] = {"g5tul_005e", "g5tul_005"},
    ["LIGHT_LEFT"] = {"g5tul_002e", "g5tul_002"},
    ["KEEP_LEFT"] = {"g5tul_001e", "g5tul_001"},
    ["nil"] = {nil, nil},
    ["UNDEFINED"] = {nil, nil}
}


maneuver_check = {
    ["END"] = {"g5ann_001e_alt2", "g5ann_001e_alt2"},              -- You will reach your destination
    ["STOPOVER"] = {"g5ann_002e_alt2", "g5ann_002e_alt2"},         -- You will reached a stopover 
    ["JUNCTION"] = {nil, nil},                                     -- No voice file needed -> check maneuver_turn
    ["PASS_JUNCTION"] = {nil, nil},                                -- the junction
    ["ROUNDABOUT"] = {"g5mod_005", "g5mod_005"},                   -- At the roundabout
    ["EXIT_ROUNDABOUT"] = {"g5ext_000e", "g5ext_000"},             -- take the exit
    ["UTURN"] = {"g5man_004e", "g5man_004"},                       -- Make a uturn
    ["ENTER_HIGHWAY"] = {"g5man_005e", "g5man_005"},
    ["LEAVE_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},               -- take the exit
    ["CHANGE_HIGHWAY"] = {"g5man_006e", "g5man_006"},
    ["CONTINUE_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},
    ["ENTER_URBAN_HIGHWAY"] = {"g5man_005e", "g5man_005"},
    ["LEAVE_URBAN_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},         -- take the exit
    ["CHANGE_URBAN_HIGHWAY"] = {"g5man_006e", "g5man_006"},
    ["CONTINUE_URBAN_HIGHWAY"] = {"g5ext_000e", "g5ext_000"},
    ["DRIVE_TO_NEAREST_ROAD"] = {"g5serv_001", "g5serv_001"},      -- drive to nearest road 
    ["FERRY"] = {"g5serv_004e", "g5serv_004"}
}


exit_number_check = {
    [1] = {"g5ext_001e","g5ext_001"},                   -- take the first exit
    [2] = {"g5ext_002e","g5ext_002"},                   -- take the second exit
    [3] = {"g5ext_003e","g5ext_003"},                   -- take the third exit
    [4] = {"g5ext_004e","g5ext_004"},                   -- take the fourth exit
    [5] = {"g5ext_005e","g5ext_005"},                   -- take the fifth exit
    [6] = {"g5ext_006e","g5ext_006"},                   -- take the sixth exit
    [7] = {"g5ext_007e","g5ext_007"},                   -- take the seventh exit
    [8] = {"g5ext_008e","g5ext_008"},                   -- take the eighth exit
    [9] = {"g5ext_009e","g5ext_009"},                   -- take the ninth exit
    [10] = {"g5ext_010e","g5ext_010"},                  -- take the tenth exit
    [11] = {"g5ext_011e","g5ext_011"},                  -- take the eleventh exit
    [12] = {"g5ext_012e","g5ext_012"}                   -- take the twelfth exit
}

distances = {
    [50] = "g5num_050",
    [100] = "g5num_100",
    [150] = "g5num_150",
    [200] = "g5num_200",
    [250] = "g5num_250",
    [300] = "g5num_300",
    [400] = "g5num_400",
    [500] = "g5num_500",
    [600] = "g5num_600",
    [700] = "g5num_700",
    [800] = "g5num_800",
    [900] = "g5num_900",
    [1] = "g5num_001",
    [2] = "g5num_002",
    [3] = "g5num_003",
    [4] = "g5num_004",
    [5] = "g5num_005",
    [6] = "g5num_006",
    [7] = "g5num_007",
    [8] = "g5num_008",
    [9] = "g5num_009",
    [10] = "g5num_010"
}

unit = {                                    -- Intonation down, intonation up
    ["MILE"] = {"g5unt_007","g5unt_007"},
    ["YARDS"] = {"g5unt_006","g5unt_006"},
    ["KILOMETER"] = {"g5unt_003","g5unt_003"},
    ["METERS"] = {"g5unt_002","g5unt_002"},
    ["METER"] = {nil, nil},
    ["KILOMETERS"] = {"g5unt_004e","g5unt_004"},
    ["MILES"] = {"g5unt_008e","g5unt_008"},
    ["nil"] = {nil, nil},
    ["UNDEFINED"] = {nil, nil}
}

misc = { 
    ["beep_sound"] = "beep",
    ["gps_signal_lost_wav"] = "g5war_027e",          
    ["gps_signal_restored_wav"] = "g5war_010e",          
    ["no_gps_signal_wav"] = "g5war_028e",                    
    ["route_recalculation_wav"] = "g5war_012e",
    ["now_wav"] = "g5mod_006",
    ["destination_wav"] = "g5ann_001",
    ["stopover_wav"] = "g5ann_002e",                
    ["end_of_street_wav"] = "g5mod_004",          
    ["follow_hwy_wav"] = "g5man_008e",
    ["follow_road_e_wav"] = "g5man_002e",
    ["follow_road_wav"] = "g5man_002",
    ["the_junction_wav"] = "g5mod_017_alt1",       
    ["for_wav"] = "g5pre_002",
    ["roundabout_wav"] = "g5mod_005",
    ["after_wav"] = "g5pre_003",
    ["half_a_mile_wav"] = "g5num_0.50_mile",
    ["quarter_a_mile_wav"] = "g5num_0.25_mile",
    ["second_right_wav"] = "g5turns_right_006e",     
    ["second_left_wav"] = "g5turns_left_006e",        
    ["immediately_wav"] = "g5mod_008_alt1",          
    ["safety_camara_ahead_wav"] = "g5war_004e",
    ["over_speed_limit_wav"] = "g5war_016",
    ["traffic_automatic_detour_wav"] = "g5war_018e",          
    ["traffic_manual_detour_wav"] = "g5war_017e",            
    ["no_detour_possible"] = "g5war_021e",                
    ["and_then_wav"] = "g5con_001"

}

right = { ["QUITE_RIGHT"] = 0, ["HEAVY_RIGHT"] = 0, ["LIGHT_RIGHT"] = 0, ["KEEP_RIGHT"] = 0 }
left = { ["QUITE_LEFT"] = 0, ["HEAVY_LEFT"] = 0, ["LIGHT_LEFT"] = 0, ["KEEP_LEFT"] = 0 }


check_files = { maneuver_turns, maneuver_check, exit_number_check, distances, unit, misc }